/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.gui.ExtensionFileFilter;
import proguard.gui.FilterDialog;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;
import proguard.util.ListUtil;

class ClassPathPanel
extends ListPanel {
    private final JFrame owner;
    private final boolean inputAndOutput;
    private final JFileChooser chooser;
    private final FilterDialog filterDialog;

    public ClassPathPanel(JFrame jFrame, boolean bl) {
        this.firstSelectionButton = bl ? 3 : 2;
        this.owner = jFrame;
        this.inputAndOutput = bl;
        this.list.setCellRenderer(new MyListCellRenderer());
        this.chooser = new JFileChooser("");
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.addChoosableFileFilter(new ExtensionFileFilter(ClassPathPanel.msg("jarExtensions"), new String[]{".apk", ".ap_", ".jar", ".aar", ".war", ".ear", ".zip"}));
        this.chooser.setApproveButtonText(ClassPathPanel.msg("ok"));
        this.filterDialog = new FilterDialog(jFrame, ClassPathPanel.msg("enterFilter"));
        this.addAddButton(bl, false);
        if (bl) {
            this.addAddButton(bl, true);
        }
        this.addEditButton();
        this.addFilterButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddButton(boolean bl, final boolean bl2) {
        JButton jButton = new JButton(ClassPathPanel.msg(bl ? (bl2 ? "addOutput" : "addInput") : "add"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassPathPanel.this.chooser.setDialogTitle(ClassPathPanel.msg("addJars"));
                ClassPathPanel.this.chooser.setSelectedFile(null);
                ClassPathPanel.this.chooser.setSelectedFiles(null);
                int n = ClassPathPanel.this.chooser.showOpenDialog(ClassPathPanel.this.owner);
                if (n == 0) {
                    File[] fileArray = ClassPathPanel.this.chooser.getSelectedFiles();
                    Object[] objectArray = ClassPathPanel.this.classPathEntries(fileArray, bl2);
                    ClassPathPanel.this.addElements(objectArray);
                }
            }
        });
        this.addButton(ClassPathPanel.tip(jButton, bl ? (bl2 ? "addOutputTip" : "addInputTip") : "addTip"));
    }

    protected void addEditButton() {
        JButton jButton = new JButton(ClassPathPanel.msg("edit"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray;
                int n;
                boolean bl = false;
                int[] nArray = ClassPathPanel.this.list.getSelectedIndices();
                File[] fileArray = new File[nArray.length];
                for (n = 0; n < fileArray.length; ++n) {
                    objectArray = (Object[])ClassPathPanel.this.listModel.getElementAt(nArray[n]);
                    bl = objectArray.isOutput();
                    fileArray[n] = objectArray.getFile();
                }
                ClassPathPanel.this.chooser.setDialogTitle(ClassPathPanel.msg("chooseJars"));
                ClassPathPanel.this.chooser.setSelectedFile(fileArray[0].getAbsoluteFile());
                ClassPathPanel.this.chooser.setSelectedFiles(fileArray);
                n = ClassPathPanel.this.chooser.showOpenDialog(ClassPathPanel.this.owner);
                if (n == 0) {
                    fileArray = ClassPathPanel.this.chooser.getSelectedFiles();
                    objectArray = ClassPathPanel.this.classPathEntries(fileArray, bl);
                    if (nArray.length == fileArray.length) {
                        ClassPathPanel.this.setElementsAt(objectArray, nArray);
                    } else {
                        ClassPathPanel.this.removeElementsAt(nArray);
                        ClassPathPanel.this.addElements(objectArray);
                    }
                }
            }
        });
        this.addButton(ClassPathPanel.tip(jButton, "editTip"));
    }

    protected void addFilterButton() {
        JButton jButton = new JButton(ClassPathPanel.msg("filter"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ClassPathPanel.this.list.isSelectionEmpty()) {
                    int[] nArray = ClassPathPanel.this.list.getSelectedIndices();
                    ClassPathPanel.this.getFiltersFrom(nArray[0]);
                    int n = ClassPathPanel.this.filterDialog.showDialog();
                    if (n == 0) {
                        ClassPathPanel.this.setFiltersAt(nArray);
                    }
                }
            }
        });
        this.addButton(ClassPathPanel.tip(jButton, "filterTip"));
    }

    public void setClassPath(ClassPath classPath) {
        this.listModel.clear();
        if (classPath != null) {
            for (int i = 0; i < classPath.size(); ++i) {
                this.listModel.addElement(classPath.get(i));
            }
        }
        this.enableSelectionButtons();
    }

    public ClassPath getClassPath() {
        int n = this.listModel.size();
        if (n == 0) {
            return null;
        }
        ClassPath classPath = new ClassPath();
        for (int i = 0; i < n; ++i) {
            classPath.add((ClassPathEntry)this.listModel.get(i));
        }
        return classPath;
    }

    private ClassPathEntry[] classPathEntries(File[] fileArray, boolean bl) {
        ClassPathEntry[] classPathEntryArray = new ClassPathEntry[fileArray.length];
        for (int i = 0; i < classPathEntryArray.length; ++i) {
            classPathEntryArray[i] = new ClassPathEntry(fileArray[i], bl);
        }
        return classPathEntryArray;
    }

    private void getFiltersFrom(int n) {
        ClassPathEntry classPathEntry = (ClassPathEntry)this.listModel.get(n);
        this.filterDialog.setFilter(classPathEntry.getFilter());
        this.filterDialog.setApkFilter(classPathEntry.getApkFilter());
        this.filterDialog.setJarFilter(classPathEntry.getJarFilter());
        this.filterDialog.setAarFilter(classPathEntry.getAarFilter());
        this.filterDialog.setWarFilter(classPathEntry.getWarFilter());
        this.filterDialog.setEarFilter(classPathEntry.getEarFilter());
        this.filterDialog.setZipFilter(classPathEntry.getZipFilter());
    }

    private void setFiltersAt(int[] nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            ClassPathEntry classPathEntry = (ClassPathEntry)this.listModel.get(nArray[i]);
            classPathEntry.setFilter(this.filterDialog.getFilter());
            classPathEntry.setApkFilter(this.filterDialog.getApkFilter());
            classPathEntry.setJarFilter(this.filterDialog.getJarFilter());
            classPathEntry.setAarFilter(this.filterDialog.getAarFilter());
            classPathEntry.setWarFilter(this.filterDialog.getWarFilter());
            classPathEntry.setEarFilter(this.filterDialog.getEarFilter());
            classPathEntry.setZipFilter(this.filterDialog.getZipFilter());
        }
        this.list.setSelectedIndices(nArray);
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(ClassPathPanel.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }

    private class MyListCellRenderer
    implements ListCellRenderer {
        private static final String ARROW_IMAGE_FILE = "arrow.gif";
        private final JPanel cellPanel = new JPanel(new GridBagLayout());
        private final JLabel iconLabel = new JLabel("", 4);
        private final JLabel jarNameLabel = new JLabel("", 4);
        private final JLabel filterLabel = new JLabel("", 4);
        private final Icon arrowIcon;

        public MyListCellRenderer() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(1, 2, 1, 2);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = gridBagConstraints.insets;
            this.arrowIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(ARROW_IMAGE_FILE)));
            this.cellPanel.add((Component)this.iconLabel, gridBagConstraints);
            this.cellPanel.add((Component)this.jarNameLabel, gridBagConstraints);
            this.cellPanel.add((Component)this.filterLabel, gridBagConstraints2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ClassPathEntry classPathEntry = (ClassPathEntry)object;
            if (ClassPathPanel.this.inputAndOutput && classPathEntry.isOutput()) {
                this.iconLabel.setIcon(this.arrowIcon);
            } else {
                this.iconLabel.setIcon(null);
            }
            this.jarNameLabel.setText(classPathEntry.getName());
            StringBuffer stringBuffer = null;
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getZipFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getEarFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getWarFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getAarFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getJarFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getApkFilter());
            stringBuffer = this.appendFilter(stringBuffer, classPathEntry.getFilter());
            if (stringBuffer != null) {
                stringBuffer.append(')');
            }
            this.filterLabel.setText(stringBuffer != null ? stringBuffer.toString() : "");
            if (bl) {
                this.cellPanel.setBackground(jList.getSelectionBackground());
                this.jarNameLabel.setForeground(jList.getSelectionForeground());
                this.filterLabel.setForeground(jList.getSelectionForeground());
            } else {
                this.cellPanel.setBackground(jList.getBackground());
                this.jarNameLabel.setForeground(jList.getForeground());
                this.filterLabel.setForeground(jList.getForeground());
            }
            if (!(ClassPathPanel.this.inputAndOutput && classPathEntry.isOutput() || classPathEntry.getFile().canRead())) {
                this.jarNameLabel.setForeground(Color.red);
            }
            this.cellPanel.setOpaque(true);
            return this.cellPanel;
        }

        private StringBuffer appendFilter(StringBuffer stringBuffer, List list) {
            if (stringBuffer != null) {
                stringBuffer.append(';');
            }
            if (list != null) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer().append('(');
                }
                stringBuffer.append(ListUtil.commaSeparatedString(list, true));
            }
            return stringBuffer;
        }
    }
}

