/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.util.Utils;
import com.baselet.diagram.DiagramHandler;
import com.baselet.gui.command.Command;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpPanelChanged
extends Command {
    private final String changed_to;
    private String changed_from;

    public HelpPanelChanged(String text) {
        this.changed_to = text;
    }

    private HelpPanelChanged(String changed_from, String changed_to) {
        this.changed_from = changed_from;
        this.changed_to = changed_to;
    }

    public static Double getFontsize(String text) {
        if (text == null) {
            return null;
        }
        Pattern p = Pattern.compile("fontsize=(\\d+(\\.\\d+)?)( .*)?");
        Vector<String> txt = Utils.decomposeStrings(text);
        for (String t : txt) {
            Matcher m = p.matcher(t);
            if (!m.matches()) continue;
            return Double.parseDouble(m.group(1));
        }
        return null;
    }

    public static String getFontfamily(String text) {
        if (text == null) {
            return null;
        }
        Pattern p = Pattern.compile("fontfamily\\=(\\w+).*");
        Vector<String> txt = Utils.decomposeStrings(text);
        for (String t : txt) {
            Matcher m = p.matcher(t);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return null;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        this.changed_from = handler.getHelpText();
        handler.setHelpText(this.changed_to);
        handler.getFontHandler().setDiagramDefaultFontSize(HelpPanelChanged.getFontsize(this.changed_to));
        handler.getFontHandler().setDiagramDefaultFontFamily(HelpPanelChanged.getFontfamily(this.changed_to));
        handler.getDrawPanel().updateElements();
        handler.getDrawPanel().repaint();
    }

    @Override
    public void undo(DiagramHandler handler) {
        super.undo(handler);
        handler.setHelpText(this.changed_from);
        handler.getFontHandler().setDiagramDefaultFontSize(HelpPanelChanged.getFontsize(this.changed_from));
        handler.getFontHandler().setDiagramDefaultFontFamily(HelpPanelChanged.getFontfamily(this.changed_from));
        handler.getDrawPanel().updateElements();
        handler.getDrawPanel().repaint();
    }

    @Override
    public boolean isMergeableTo(Command c) {
        return c instanceof HelpPanelChanged;
    }

    @Override
    public Command mergeTo(Command c) {
        HelpPanelChanged tmp = (HelpPanelChanged)c;
        HelpPanelChanged ret = new HelpPanelChanged(tmp.changed_from, this.changed_to);
        return ret;
    }
}

