/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.element.UndoInformation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoHistory {
    private final Logger log = LoggerFactory.getLogger(UndoHistory.class);
    private final List<UndoInformation> history = new ArrayList<UndoInformation>();
    private int currentIndex = -1;

    public void add(UndoInformation undoInformation) {
        while (this.history.size() > this.currentIndex + 1) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(undoInformation);
        ++this.currentIndex;
    }

    public UndoInformation remove() {
        UndoInformation undoInformation = this.history.remove(this.currentIndex);
        this.currentIndex = Math.min(this.currentIndex, this.history.size() - 1);
        return undoInformation;
    }

    public UndoInformation get(boolean undo) {
        if (this.history.isEmpty()) {
            return null;
        }
        if (!undo) {
            ++this.currentIndex;
        }
        UndoInformation undoInformation = this.history.get(this.currentIndex);
        this.log.trace("GET " + this.currentIndex + " = " + undoInformation.getDiffRectangle(10, undo) + "/size" + this.history.size());
        if (undo) {
            --this.currentIndex;
        }
        return undoInformation;
    }
}

