/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.MetaClassNodeGen;

@NodeChildren(value={@NodeChild(value="instance"), @NodeChild(value="module")})
public abstract class IsANode
extends RubyNode {
    @Node.Child
    private MetaClassNode metaClassNode;

    public IsANode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract boolean executeIsA(Object var1, DynamicObject var2);

    @Specialization(limit="getCacheLimit()", guards={"isRubyModule(cachedModule)", "getMetaClass(self) == cachedMetaClass", "module == cachedModule"}, assumptions={"getUnmodifiedAssumption(cachedModule)"})
    public boolean isACached(Object self, DynamicObject module, @Cached(value="getMetaClass(self)") DynamicObject cachedMetaClass, @Cached(value="module") DynamicObject cachedModule, @Cached(value="isA(cachedMetaClass, cachedModule)") boolean result) {
        return result;
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @Specialization(guards={"isRubyModule(module)"}, contains={"isACached"})
    public boolean isAUncached(Object self, DynamicObject module) {
        return this.isA(this.getMetaClass(self), module);
    }

    @Specialization(guards={"!isRubyModule(module)"})
    public boolean isATypeError(Object self, DynamicObject module) {
        throw new RaiseException(this.coreExceptions().typeError("class or module required", this));
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isA(DynamicObject metaClass, DynamicObject module) {
        return ModuleOperations.assignableTo(metaClass, module);
    }

    protected DynamicObject getMetaClass(Object object) {
        if (this.metaClassNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.metaClassNode = this.insert(MetaClassNodeGen.create(this.getContext(), null, null));
        }
        return this.metaClassNode.executeMetaClass(object);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().IS_A_CACHE;
    }
}

