/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509ExtensionFactory
extends RubyObject {
    private static final long serialVersionUID = 3180447029639456500L;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509ExtensionFactory(runtime, klass);
        }
    };
    private static final String DNS_ = "DNS:";
    private static final String DNS_Name_ = "DNS Name:";
    private static final String URI_ = "URI:";
    private static final String RID_ = "RID:";
    private static final String email_ = "email:";
    private static final String dirName_ = "dirName:";
    private static final String otherName_ = "otherName:";

    static void createX509ExtensionFactory(Ruby runtime, RubyModule _X509) {
        RubyClass _ExtensionFactory = _X509.defineClassUnder("ExtensionFactory", runtime.getObject(), ALLOCATOR);
        _ExtensionFactory.defineAnnotatedMethods(X509ExtensionFactory.class);
    }

    public X509ExtensionFactory(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block unusedBlock) {
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)4);
        if (args.length > 0 && !args[0].isNil()) {
            this.set_issuer_cert(args[0]);
        }
        if (args.length > 1 && !args[1].isNil()) {
            this.set_subject_cert(args[1]);
        }
        if (args.length > 2 && !args[2].isNil()) {
            this.set_subject_req(args[2]);
        }
        if (args.length > 3 && !args[3].isNil()) {
            this.set_crl(args[3]);
        }
        return this;
    }

    @JRubyMethod(name={"issuer_certificate"})
    public IRubyObject issuer_cert() {
        return this.getInstanceVariable("@issuer_certificate");
    }

    @JRubyMethod(name={"issuer_certificate="})
    public IRubyObject set_issuer_cert(IRubyObject arg) {
        this.setInstanceVariable("@issuer_certificate", arg);
        return arg;
    }

    @JRubyMethod(name={"subject_certificate"})
    public IRubyObject subject_cert() {
        return this.getInstanceVariable("@subject_certificate");
    }

    @JRubyMethod(name={"subject_certificate="})
    public IRubyObject set_subject_cert(IRubyObject arg) {
        this.setInstanceVariable("@subject_certificate", arg);
        return arg;
    }

    @JRubyMethod(name={"subject_request"})
    public IRubyObject subject_req() {
        return this.getInstanceVariable("@subject_request");
    }

    @JRubyMethod(name={"subject_request="})
    public IRubyObject set_subject_req(IRubyObject arg) {
        this.setInstanceVariable("@subject_request", arg);
        return arg;
    }

    @JRubyMethod(name={"crl"})
    public IRubyObject crl() {
        return this.getInstanceVariable("@crl");
    }

    @JRubyMethod(name={"crl="})
    public IRubyObject set_crl(IRubyObject arg) {
        this.setInstanceVariable("@crl", arg);
        return arg;
    }

    @JRubyMethod(name={"config"})
    public IRubyObject config() {
        return this.getInstanceVariable("@config");
    }

    @JRubyMethod(name={"config="})
    public IRubyObject set_config(IRubyObject arg) {
        this.setInstanceVariable("@config", arg);
        return arg;
    }

    @JRubyMethod(rest=true)
    public IRubyObject create_ext(ThreadContext context2, IRubyObject[] args) {
        Object value2;
        ASN1ObjectIdentifier objectId;
        Ruby runtime = context2.runtime;
        Object critical = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)3) == 3 && !args[2].isNil() ? args[2] : runtime.getFalse();
        String oid2 = args[0].toString();
        String valuex = args[1].toString();
        try {
            objectId = ASN1.getObjectID(runtime, oid2);
        }
        catch (IllegalArgumentException e) {
            OpenSSL.debug(runtime, "ASN1.getObjectIdentifier() at ExtensionFactory.create_ext", e);
            throw X509Extension.newExtensionError(runtime, "unknown OID `" + oid2 + "'");
        }
        String critical_ = "critical,";
        if (valuex.startsWith("critical,")) {
            critical = runtime.getTrue();
            valuex = valuex.substring("critical,".length()).trim();
        }
        try {
            String id2 = objectId.getId();
            value2 = id2.equals("2.5.29.14") ? new DEROctetString((ASN1Encodable)this.parseSubjectKeyIdentifier(context2, oid2, valuex)) : (id2.equals("2.5.29.35") ? this.parseAuthorityKeyIdentifier(context2, valuex) : (id2.equals("2.5.29.17") ? X509ExtensionFactory.parseSubjectAltName(valuex) : (id2.equals("2.5.29.18") ? this.parseIssuerAltName(context2, valuex) : (id2.equals("2.5.29.19") ? X509ExtensionFactory.parseBasicConstrains(valuex) : (id2.equals("2.5.29.15") ? this.parseKeyUsage(oid2, valuex) : (id2.equals("2.16.840.1.113730.1.1") ? this.parseNsCertType(oid2, valuex) : (id2.equals("2.5.29.37") ? X509ExtensionFactory.parseExtendedKeyUsage(valuex) : new DEROctetString(new DEROctetString(ByteList.plain((CharSequence)valuex)).getEncoded("DER")))))))));
        }
        catch (IOException e) {
            throw X509Extension.newExtensionError(runtime, "Unable to create extension: " + e.getMessage());
        }
        return X509Extension.newExtension(runtime, objectId, (ASN1Encodable)value2, (boolean)(critical.isNil() ? null : Boolean.valueOf(critical.isTrue())));
    }

    @JRubyMethod(rest=true)
    public IRubyObject create_extension(ThreadContext context2, IRubyObject[] args) {
        if (args.length > 1) {
            return this.create_ext(context2, args);
        }
        IRubyObject arg = args[0];
        if (arg instanceof RubyArray) {
            return this.create_ext_from_array(context2, arg);
        }
        if (arg instanceof RubyHash) {
            return this.create_ext_from_hash(context2, arg);
        }
        if (arg instanceof RubyString) {
            return this.create_ext_from_string(context2, arg);
        }
        throw context2.runtime.newArgumentError("unexpected argument: " + arg.inspect());
    }

    @JRubyMethod
    public IRubyObject create_ext_from_array(ThreadContext context2, IRubyObject arg) {
        RubyArray ary = (RubyArray)arg;
        if (ary.size() > 3) {
            throw X509Extension.newExtensionError(context2.runtime, "unexpected array form");
        }
        return this.create_ext(context2, ary.toJavaArrayUnsafe());
    }

    @JRubyMethod
    public IRubyObject create_ext_from_hash(ThreadContext context2, IRubyObject arg) {
        RubyHash hash2 = (RubyHash)arg;
        Ruby runtime = context2.runtime;
        IRubyObject oid2 = hash2.op_aref(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "oid"));
        IRubyObject value2 = hash2.op_aref(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "value"));
        IRubyObject critical = hash2.op_aref(context2, (IRubyObject)StringHelper.newStringFrozen(runtime, "critical"));
        return this.create_ext(context2, new IRubyObject[]{oid2, value2, critical});
    }

    @JRubyMethod
    public IRubyObject create_ext_from_string(ThreadContext context2, IRubyObject arg) {
        RubyString str = (RubyString)arg;
        Ruby runtime = context2.runtime;
        RubyInteger i2 = str.index19(context2, (IRubyObject)StringHelper.newString(runtime, new byte[]{61})).convertToInteger("to_i");
        int ind = (int)i2.getLongValue();
        RubyString oid2 = (RubyString)str.substr19(runtime, 0, ind);
        oid2.strip_bang19(context2);
        int len = (int)str.length19().getLongValue() - ind;
        RubyString value2 = (RubyString)str.substr19(runtime, ind + 1, len);
        value2.lstrip_bang19(context2);
        IRubyObject critical = context2.nil;
        if (value2.start_with_p(context2, (IRubyObject)StringHelper.newString(runtime, X509Extension.critical__)).isTrue()) {
            critical = runtime.newBoolean(true);
            value2.op_aset19(context2, (IRubyObject)runtime.newFixnum(0), (IRubyObject)runtime.newFixnum(X509Extension.critical__.length), (IRubyObject)RubyString.newEmptyString((Ruby)runtime));
        }
        value2.strip_bang19(context2);
        return this.create_ext(context2, new IRubyObject[]{oid2, value2, critical});
    }

    private DERBitString parseKeyUsage(String oid2, String valuex) {
        int i2;
        byte[] inp;
        try {
            String[] val = StringHelper.split(valuex, ':');
            inp = new byte[val.length];
            for (i2 = 0; i2 < val.length; ++i2) {
                inp[i2] = (byte)Integer.parseInt(val[i2], 16);
            }
        }
        catch (NumberFormatException e) {
            inp = null;
        }
        if (inp == null && valuex.length() < 3) {
            inp = ByteList.plain((CharSequence)valuex);
        }
        if (inp == null) {
            byte[] byArray;
            byte v1 = 0;
            int v2 = 0;
            String[] val = StringHelper.split(valuex, ',');
            for (int i3 = 0; i3 < val.length; ++i3) {
                String value2 = val[i3].trim();
                if ("decipherOnly".equals(value2) || "Decipher Only".equals(value2)) {
                    v2 = (byte)(v2 | 0xFFFFFF80);
                    continue;
                }
                if ("digitalSignature".equals(value2) || "Digital Signature".equals(value2)) {
                    v1 = (byte)(v1 | 0xFFFFFF80);
                    continue;
                }
                if ("nonRepudiation".equals(value2) || "Non Repudiation".equals(value2)) {
                    v1 = (byte)(v1 | 0x40);
                    continue;
                }
                if ("keyEncipherment".equals(value2) || "Key Encipherment".equals(value2)) {
                    v1 = (byte)(v1 | 0x20);
                    continue;
                }
                if ("dataEncipherment".equals(value2) || "Data Encipherment".equals(value2)) {
                    v1 = (byte)(v1 | 0x10);
                    continue;
                }
                if ("keyAgreement".equals(value2) || "Key Agreement".equals(value2)) {
                    v1 = (byte)(v1 | 8);
                    continue;
                }
                if ("keyCertSign".equals(value2) || "Key Cert Sign".equals(value2)) {
                    v1 = (byte)(v1 | 4);
                    continue;
                }
                if ("cRLSign".equals(value2)) {
                    v1 = (byte)(v1 | 2);
                    continue;
                }
                if ("encipherOnly".equals(value2) || "Encipher Only".equals(value2)) {
                    v1 = (byte)(v1 | 1);
                    continue;
                }
                throw X509Extension.newExtensionError(this.getRuntime(), oid2 + " = " + valuex + ": unknown bit string argument");
            }
            if (v2 == 0) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = v1;
            } else {
                byte[] byArray3 = new byte[2];
                byArray3[0] = v1;
                byArray = byArray3;
                byArray3[1] = v2;
            }
            inp = byArray;
        }
        int unused = 0;
        for (i2 = inp.length - 1; i2 > -1; --i2) {
            if (inp[i2] == 0) {
                unused += 8;
                continue;
            }
            byte a2 = inp[i2];
            int x = 8;
            while (a2 != 0) {
                a2 = (byte)(a2 << 1);
                --x;
            }
            unused += x;
            break;
        }
        return new DERBitString(inp, unused);
    }

    private DERBitString parseNsCertType(String oid2, String valuex) {
        byte v = 0;
        if (valuex.length() < 3) {
            byte[] inp = ByteList.plain((CharSequence)valuex);
            v = inp[0];
        } else {
            String[] val = StringHelper.split(valuex, ',');
            for (int i2 = 0; i2 < val.length; ++i2) {
                String value2 = val[i2].trim();
                if ("SSL Client".equals(value2) || "client".equals(value2)) {
                    v = (byte)(v | 0xFFFFFF80);
                    continue;
                }
                if ("SSL Server".equals(value2) || "server".equals(value2)) {
                    v = (byte)(v | 0x40);
                    continue;
                }
                if ("S/MIME".equals(value2) || "email".equals(value2)) {
                    v = (byte)(v | 0x20);
                    continue;
                }
                if ("Object Signing".equals(value2) || "objsign".equals(value2)) {
                    v = (byte)(v | 0x10);
                    continue;
                }
                if ("Unused".equals(value2) || "reserved".equals(value2)) {
                    v = (byte)(v | 8);
                    continue;
                }
                if ("SSL CA".equals(value2) || "sslCA".equals(value2)) {
                    v = (byte)(v | 4);
                    continue;
                }
                if ("S/MIME CA".equals(value2) || "emailCA".equals(value2)) {
                    v = (byte)(v | 2);
                    continue;
                }
                if ("Object Signing CA".equals(value2) || "objCA".equals(value2)) {
                    v = (byte)(v | 1);
                    continue;
                }
                throw X509Extension.newExtensionError(this.getRuntime(), oid2 + " = " + valuex + ": unknown bit string argument");
            }
        }
        int unused = 0;
        if (v == 0) {
            unused += 8;
        } else {
            byte a2 = v;
            int x = 8;
            while (a2 != 0) {
                a2 = (byte)(a2 << 1);
                --x;
            }
            unused += x;
        }
        return new DERBitString(new byte[]{v}, unused);
    }

    private static DLSequence parseBasicConstrains(String valuex) {
        String value2;
        int i2;
        String[] val = StringHelper.split(valuex, ',');
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (i2 = 0; i2 < val.length; ++i2) {
            val[i2] = val[i2].trim();
            value2 = val[i2];
            if (value2.length() <= 3 || !value2.substring(0, 3).equalsIgnoreCase("CA:")) continue;
            boolean isTrue = "true".equalsIgnoreCase(value2.substring(3).trim());
            vec.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)isTrue));
        }
        for (i2 = 0; i2 < val.length; ++i2) {
            value2 = val[i2];
            if (value2.length() <= 8 || !value2.substring(0, 8).equalsIgnoreCase("pathlen:")) continue;
            int pathlen = Integer.parseInt(value2.substring(8).trim());
            vec.add((ASN1Encodable)new ASN1Integer(BigInteger.valueOf(pathlen)));
        }
        return new DLSequence(vec);
    }

    private DLSequence parseAuthorityKeyIdentifier(ThreadContext context2, String valuex) {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (valuex.startsWith("keyid:always")) {
            vec.add((ASN1Encodable)new DEROctetString(this.derDigest(context2)));
        } else if (valuex.startsWith("keyid")) {
            vec.add((ASN1Encodable)new DEROctetString(this.derDigest(context2)));
        }
        return new DLSequence(vec);
    }

    private byte[] derDigest(ThreadContext context2) {
        IRubyObject der;
        Ruby runtime = context2.runtime;
        IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(context2, "public_key");
        if (pkey instanceof PKeyRSA) {
            der = pkey.callMethod(context2, "to_der");
        } else {
            der = ASN1.decode(context2, (IRubyObject)ASN1._ASN1(runtime), pkey.callMethod(context2, "to_der"));
            der = der.callMethod(context2, "value").callMethod(context2, "[]", (IRubyObject)runtime.newFixnum(1)).callMethod(context2, "value");
        }
        return X509ExtensionFactory.getSHA1Digest(runtime, der.asString().getBytes());
    }

    private static byte[] getSHA1Digest(Ruby runtime, byte[] bytes) {
        try {
            return SecurityHelper.getMessageDigest("SHA-1").digest(bytes);
        }
        catch (GeneralSecurityException e) {
            throw X509Extension.newExtensionError(runtime, e.getMessage());
        }
    }

    private ASN1Encodable parseIssuerAltName(ThreadContext context2, String valuex) throws IOException {
        if (valuex.startsWith("issuer:copy")) {
            RubyArray exts = (RubyArray)this.getInstanceVariable("@issuer_certificate").callMethod(context2, "extensions");
            for (int i2 = 0; i2 < exts.size(); ++i2) {
                X509Extension ext2 = (X509Extension)exts.entry(i2);
                String oid2 = ext2.getRealObjectID().getId();
                if (!"2.5.29.17".equals(oid2)) continue;
                return ext2.getRealValue();
            }
        }
        throw new IOException("Malformed IssuerAltName: " + valuex);
    }

    private static ASN1Encodable parseSubjectAltName(String valuex) throws IOException {
        if (valuex.startsWith(DNS_)) {
            String dns = valuex.substring(DNS_.length());
            return new GeneralName(2, dns);
        }
        if (valuex.startsWith(DNS_Name_)) {
            String dns = valuex.substring(DNS_Name_.length());
            return new GeneralName(2, dns);
        }
        if (valuex.startsWith(URI_)) {
            String uri = valuex.substring(URI_.length());
            return new GeneralName(6, uri);
        }
        if (valuex.startsWith(RID_)) {
            String rid = valuex.substring(RID_.length());
            return new GeneralName(8, rid);
        }
        if (valuex.startsWith(email_)) {
            String mail = valuex.substring(email_.length());
            return new GeneralName(1, mail);
        }
        if (valuex.startsWith("IP:") || valuex.startsWith("IP Address:")) {
            int idx = valuex.charAt(2) == ':' ? 3 : 11;
            String[] vals = valuex.substring(idx).split("\\.|::");
            byte[] ip = new byte[vals.length];
            for (int i2 = 0; i2 < vals.length; ++i2) {
                ip[i2] = (byte)(Integer.parseInt(vals[i2]) & 0xFF);
            }
            return new GeneralName(7, (ASN1Encodable)new DEROctetString(ip));
        }
        if (valuex.startsWith("other")) {
            String other = valuex.substring(otherName_.length());
            return new GeneralName(0, other);
        }
        if (valuex.startsWith("dir")) {
            String dir = valuex.substring(dirName_.length());
            return new GeneralName(4, dir);
        }
        throw new IOException("could not parse SubjectAltName: " + valuex);
    }

    private DEROctetString parseSubjectKeyIdentifier(ThreadContext context2, String oid2, String valuex) {
        if ("hash".equalsIgnoreCase(valuex)) {
            return new DEROctetString(this.derDigest(context2));
        }
        if (valuex.length() == 20 || !X509Extension.isHex(valuex)) {
            return new DEROctetString(ByteList.plain((CharSequence)valuex));
        }
        int len = valuex.length();
        ByteList hex = new ByteList(len / 2 + 1);
        for (int i2 = 0; i2 < len; i2 += 2) {
            if (i2 + 1 >= len) {
                throw X509Extension.newExtensionError(context2.runtime, oid2 + " = " + valuex + ": odd number of digits");
            }
            int c1 = X509Extension.upHex(valuex.charAt(i2));
            int c2 = X509Extension.upHex(valuex.charAt(i2 + 1));
            if (c1 != -1 && c2 != -1) {
                hex.append(c1 << 4 & 0xF0 | c2 & 0xF);
            } else {
                throw X509Extension.newExtensionError(context2.runtime, oid2 + " = " + valuex + ": illegal hex digit");
            }
            while (i2 + 2 < len && valuex.charAt(i2 + 2) == ':') {
                ++i2;
            }
        }
        byte[] hexBytes = new byte[hex.length()];
        System.arraycopy(hex.getUnsafeBytes(), hex.getBegin(), hexBytes, 0, hexBytes.length);
        return new DEROctetString(hexBytes);
    }

    private static DLSequence parseExtendedKeyUsage(String valuex) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (String name2 : valuex.split(", ?")) {
            vector.add((ASN1Encodable)ASN1Registry.sym2oid(name2));
        }
        return new DLSequence(vector);
    }
}

