/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

public class InvokePrimitiveNode
extends RubyNode {
    @Node.Child
    private RubyNode primitive;
    private final ConditionProfile primitiveSucceededCondition = ConditionProfile.createBinaryProfile();

    public InvokePrimitiveNode(RubyContext context, SourceSection sourceSection, RubyNode primitive) {
        super(context, sourceSection);
        this.primitive = primitive;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.primitive.execute(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.primitive.execute(frame);
        if (this.primitiveSucceededCondition.profile(value != null)) {
            return value;
        }
        return this.nil();
    }
}

