/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.core.cast.NameToJavaStringNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;

@GeneratedBy(value=NameToJavaStringNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class NameToJavaStringNodeGen
extends NameToJavaStringNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeStringCached_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeSymbolCached_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeJavaStringCached_;
    @Node.Child
    private BaseNode_ specialization_;

    private NameToJavaStringNodeGen(RubyNode value) {
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public String executeToJavaString(VirtualFrame frameValue, Object valueValue) {
        return this.specialization_.executeString(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static NameToJavaStringNode create(RubyNode value) {
        return new NameToJavaStringNodeGen(value);
    }

    @GeneratedBy(methodName="coerceObjectToStr(VirtualFrame, Object, BranchProfile, CallDispatchHeadNode)", value=NameToJavaStringNode.class)
    private static final class CoerceObjectToStrNode_
    extends BaseNode_ {
        private final BranchProfile errorProfile;
        @Node.Child
        private CallDispatchHeadNode toStr;

        CoerceObjectToStrNode_(NameToJavaStringNodeGen root, BranchProfile errorProfile, CallDispatchHeadNode toStr) {
            super(root, 7);
            this.errorProfile = errorProfile;
            this.toStr = toStr;
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            if (!(RubyGuards.isString(valueValue) || RubyGuards.isRubySymbol(valueValue) || RubyGuards.isRubyString(valueValue))) {
                return this.root.coerceObjectToStr(frameValue, valueValue, this.errorProfile, this.toStr);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root, BranchProfile errorProfile, CallDispatchHeadNode toStr) {
            return new CoerceObjectToStrNode_(root, errorProfile, toStr);
        }
    }

    @GeneratedBy(methodName="javaStringUncached(String)", value=NameToJavaStringNode.class)
    private static final class JavaStringUncachedNode_
    extends BaseNode_ {
        JavaStringUncachedNode_(NameToJavaStringNodeGen root) {
            super(root, 6);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof String) {
                String valueValue_ = (String)valueValue;
                return this.root.javaStringUncached(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root) {
            return new JavaStringUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="javaStringCached(String, String)", value=NameToJavaStringNode.class)
    private static final class JavaStringCachedNode_
    extends BaseNode_ {
        private final String cachedString;

        JavaStringCachedNode_(NameToJavaStringNodeGen root, String cachedString) {
            super(root, 5);
            this.cachedString = cachedString;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            if (newNode.getClass() == JavaStringUncachedNode_.class) {
                this.removeSame("Contained by javaStringUncached(String)");
            }
            return super.merge(newNode, frameValue, valueValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object valueValue) {
            String valueValue_;
            return valueValue instanceof String && (valueValue_ = (String)valueValue) == this.cachedString;
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            String valueValue_;
            if (valueValue instanceof String && (valueValue_ = (String)valueValue) == this.cachedString) {
                return this.root.javaStringCached(valueValue_, this.cachedString);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root, String cachedString) {
            return new JavaStringCachedNode_(root, cachedString);
        }
    }

    @GeneratedBy(methodName="symbolUncached(DynamicObject)", value=NameToJavaStringNode.class)
    private static final class SymbolUncachedNode_
    extends BaseNode_ {
        SymbolUncachedNode_(NameToJavaStringNodeGen root) {
            super(root, 4);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubySymbol(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.symbolUncached(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root) {
            return new SymbolUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="symbolCached(DynamicObject, DynamicObject, String)", value=NameToJavaStringNode.class)
    private static final class SymbolCachedNode_
    extends BaseNode_ {
        private final DynamicObject cachedSymbol;
        private final String convertedString;

        SymbolCachedNode_(NameToJavaStringNodeGen root, DynamicObject cachedSymbol, String convertedString) {
            super(root, 3);
            this.cachedSymbol = cachedSymbol;
            this.convertedString = convertedString;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            if (newNode.getClass() == SymbolUncachedNode_.class) {
                this.removeSame("Contained by symbolUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, valueValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && (valueValue_ = (DynamicObject)valueValue) == this.cachedSymbol) {
                assert (RubyGuards.isRubySymbol(this.cachedSymbol));
                return true;
            }
            return false;
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && (valueValue_ = (DynamicObject)valueValue) == this.cachedSymbol) {
                assert (RubyGuards.isRubySymbol(this.cachedSymbol));
                return this.root.symbolCached(valueValue_, this.cachedSymbol, this.convertedString);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root, DynamicObject cachedSymbol, String convertedString) {
            return new SymbolCachedNode_(root, cachedSymbol, convertedString);
        }
    }

    @GeneratedBy(methodName="stringUncached(DynamicObject)", value=NameToJavaStringNode.class)
    private static final class StringUncachedNode_
    extends BaseNode_ {
        StringUncachedNode_(NameToJavaStringNodeGen root) {
            super(root, 2);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.stringUncached(valueValue_);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root) {
            return new StringUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="stringCached(DynamicObject, Rope, String)", value=NameToJavaStringNode.class)
    private static final class StringCachedNode_
    extends BaseNode_ {
        private final Rope cachedRope;
        private final String convertedString;

        StringCachedNode_(NameToJavaStringNodeGen root, Rope cachedRope, String convertedString) {
            super(root, 1);
            this.cachedRope = cachedRope;
            this.convertedString = convertedString;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            if (newNode.getClass() == StringUncachedNode_.class) {
                this.removeSame("Contained by stringUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, valueValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            return valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue) && StringCachingGuards.ropesEqual(valueValue_, this.cachedRope);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyString(valueValue_ = (DynamicObject)valueValue) && StringCachingGuards.ropesEqual(valueValue_, this.cachedRope)) {
                return this.root.stringCached(valueValue_, this.cachedRope, this.convertedString);
            }
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root, Rope cachedRope, String convertedString) {
            return new StringCachedNode_(root, cachedRope, convertedString);
        }
    }

    @GeneratedBy(value=NameToJavaStringNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(NameToJavaStringNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().executeString(frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=NameToJavaStringNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(NameToJavaStringNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public String executeString(VirtualFrame frameValue, Object valueValue) {
            return (String)this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(NameToJavaStringNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=NameToJavaStringNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected NameToJavaStringNodeGen root;

        BaseNode_(NameToJavaStringNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (NameToJavaStringNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeString((VirtualFrame)frameValue, valueValue);
        }

        public abstract String executeString(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.executeString(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            Object valueValue_;
            if (valueValue instanceof DynamicObject) {
                String convertedString3;
                BaseNode_ s;
                String convertedString1;
                BaseNode_ s2;
                valueValue_ = (DynamicObject)valueValue;
                Rope cachedRope1 = StringCachingGuards.privatizeRope((DynamicObject)valueValue_);
                if (RubyGuards.isRubyString((DynamicObject)valueValue_) && StringCachingGuards.ropesEqual((DynamicObject)valueValue_, cachedRope1) && !this.root.excludeStringCached_ && this.countSame(s2 = StringCachedNode_.create(this.root, cachedRope1, convertedString1 = valueValue_.toString())) < this.root.getLimit()) {
                    return s2;
                }
                if (RubyGuards.isRubyString((DynamicObject)valueValue_)) {
                    this.root.excludeStringCached_ = true;
                    return StringUncachedNode_.create(this.root);
                }
                Object cachedSymbol3 = valueValue_;
                if (valueValue_ == cachedSymbol3 && RubyGuards.isRubySymbol((DynamicObject)cachedSymbol3) && !this.root.excludeSymbolCached_ && this.countSame(s = SymbolCachedNode_.create(this.root, (DynamicObject)cachedSymbol3, convertedString3 = this.root.symbolToString((DynamicObject)valueValue_))) < this.root.getLimit()) {
                    return s;
                }
                if (RubyGuards.isRubySymbol((DynamicObject)valueValue_)) {
                    this.root.excludeSymbolCached_ = true;
                    return SymbolUncachedNode_.create(this.root);
                }
            }
            if (valueValue instanceof String) {
                BaseNode_ s;
                Object cachedString5 = valueValue_ = (String)valueValue;
                if (valueValue_ == cachedString5 && !this.root.excludeJavaStringCached_ && this.countSame(s = JavaStringCachedNode_.create(this.root, (String)cachedString5)) < this.root.getLimit()) {
                    return s;
                }
                this.root.excludeJavaStringCached_ = true;
                return JavaStringUncachedNode_.create(this.root);
            }
            if (!(RubyGuards.isString(valueValue) || RubyGuards.isRubySymbol(valueValue) || RubyGuards.isRubyString(valueValue))) {
                BranchProfile errorProfile7 = BranchProfile.create();
                CallDispatchHeadNode toStr7 = CallDispatchHeadNode.createMethodCall();
                return CoerceObjectToStrNode_.create(this.root, errorProfile7, toStr7);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

