/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@ImportStatic(value={RubyGuards.class, ShapeCachingGuards.class})
public abstract class WriteObjectFieldNode
extends RubyBaseNode {
    private final Object name;

    public WriteObjectFieldNode(Object name) {
        this.name = name;
    }

    public Object getName() {
        return this.name;
    }

    public abstract void execute(DynamicObject var1, Object var2);

    @Specialization(guards={"location != null", "object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()", "validLocation"}, limit="getCacheLimit()")
    public void writeExistingField(DynamicObject object, Object value, @Cached(value="getLocation(object, value)") Location location, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="createAssumption()") Assumption validLocation) {
        try {
            location.set(object, value, cachedShape);
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            validLocation.invalidate();
            this.execute(object, value);
        }
    }

    @Specialization(guards={"location == null", "object.getShape() == oldShape"}, assumptions={"oldShape.getValidAssumption()", "newShape.getValidAssumption()", "validLocation"}, limit="getCacheLimit()")
    public void writeNewField(DynamicObject object, Object value, @Cached(value="getLocation(object, value)") Location location, @Cached(value="object.getShape()") Shape oldShape, @Cached(value="defineProperty(oldShape, value)") Shape newShape, @Cached(value="getNewLocation(newShape)") Location newLocation, @Cached(value="createAssumption()") Assumption validLocation) {
        try {
            newLocation.set(object, value, oldShape, newShape);
        }
        catch (IncompatibleLocationException e) {
            validLocation.invalidate();
            this.execute(object, value);
        }
    }

    @Specialization(guards={"updateShape(object)"})
    public void updateShapeAndWrite(DynamicObject object, Object value) {
        this.execute(object, value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"writeExistingField", "writeNewField", "updateShapeAndWrite"})
    public void writeUncached(DynamicObject object, Object value) {
        object.define(this.name, value, 0);
    }

    protected Location getLocation(DynamicObject object, Object value) {
        Shape oldShape = object.getShape();
        Property property = oldShape.getProperty(this.name);
        if (property != null && property.getLocation().canSet(object, value)) {
            return property.getLocation();
        }
        return null;
    }

    protected Shape defineProperty(Shape oldShape, Object value) {
        return oldShape.defineProperty(this.name, value, 0);
    }

    protected Location getNewLocation(Shape newShape) {
        return newShape.getProperty(this.name).getLocation();
    }

    protected Assumption createAssumption() {
        return Truffle.getRuntime().createAssumption("object location is valid");
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
    }
}

