/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class OpElementAsgnParseNode
extends ParseNode {
    private final ParseNode receiverNode;
    private final ParseNode argsNode;
    private final ParseNode valueNode;
    private final String operatorName;

    public OpElementAsgnParseNode(ISourcePosition position, ParseNode receiverNode, String operatorName, ParseNode argsNode, ParseNode valueNode) {
        super(position, receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.argsNode = argsNode;
        this.valueNode = valueNode;
        this.operatorName = operatorName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPELEMENTASGNNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpElementAsgnNode(this);
    }

    public ParseNode getArgsNode() {
        return this.argsNode;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public ParseNode getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isOr() {
        return this.getOperatorName() == "||";
    }

    public boolean isAnd() {
        return this.getOperatorName() == "&&";
    }

    public ParseNode getValueNode() {
        return this.valueNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.receiverNode, this.argsNode, this.valueNode);
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

