/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ReplaceObserver;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.NodeInterface;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.JSONHelper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;

public abstract class Node
implements NodeInterface,
Cloneable {
    private final NodeClass nodeClass;
    @CompilerDirectives.CompilationFinal
    private Node parent;
    private static final Object GIL = new Object();
    private static final ThreadLocal<Integer> IN_ATOMIC_BLOCK = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    static final AccessorNodes ACCESSOR = new AccessorNodes();

    protected Node() {
        CompilerAsserts.neverPartOfCompilation("do not create a Node from compiled code");
        this.nodeClass = NodeClass.get(this.getClass());
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpNewNode(this);
        }
    }

    NodeClass getNodeClass() {
        return this.nodeClass;
    }

    void setParent(Node parent) {
        this.parent = parent;
    }

    public NodeCost getCost() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.cost();
        }
        return NodeCost.MONOMORPHIC;
    }

    public SourceSection getSourceSection() {
        return null;
    }

    @ExplodeLoop
    public SourceSection getEncapsulatingSourceSection() {
        Node current = this;
        while (current != null) {
            SourceSection currentSection = current.getSourceSection();
            if (currentSection != null) {
                return currentSection;
            }
            current = current.parent;
        }
        return null;
    }

    protected final <T extends Node> T[] insert(T[] newChildren) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (newChildren != null);
        for (T newChild : newChildren) {
            this.adoptHelper((Node)newChild);
        }
        return newChildren;
    }

    protected final <T extends Node> T insert(T newChild) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        assert (newChild != null);
        this.adoptHelper(newChild);
        return newChild;
    }

    public final void adoptChildren() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        NodeUtil.adoptChildrenHelper(this);
    }

    final void adoptHelper(Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        newChild.parent = this;
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpNewChild(this, newChild);
        }
        NodeUtil.adoptChildrenHelper(newChild);
    }

    private void adoptUnadoptedHelper(final Node newChild) {
        assert (newChild != null);
        if (newChild == this) {
            throw new IllegalStateException("The parent of a node can never be the node itself.");
        }
        newChild.parent = this;
        NodeUtil.forEachChild(newChild, new NodeVisitor(){

            @Override
            public boolean visit(Node child) {
                if (child != null && child.getParent() == null) {
                    newChild.adoptUnadoptedHelper(child);
                }
                return true;
            }
        });
    }

    public Map<String, Object> getDebugProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        return properties;
    }

    public final Node getParent() {
        return this.parent;
    }

    public final <T extends Node> T replace(final T newNode, final CharSequence reason) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.atomic(new Runnable(){

            @Override
            public void run() {
                Node.this.replaceHelper(newNode, reason);
            }
        });
        return newNode;
    }

    public final <T extends Node> T replace(T newNode) {
        return this.replace(newNode, "");
    }

    final void replaceHelper(Node newNode, CharSequence reason) {
        CompilerAsserts.neverPartOfCompilation("do not call Node.replaceHelper from compiled code");
        assert (Node.inAtomicBlock());
        if (this.getParent() == null) {
            throw new IllegalStateException("This node cannot be replaced, because it does not yet have a parent.");
        }
        newNode.parent = this.parent;
        if (!NodeUtil.replaceChild(this.parent, this, newNode, true)) {
            this.parent.adoptUnadoptedHelper(newNode);
        }
        this.reportReplace(this, newNode, reason);
        this.onReplace(newNode, reason);
    }

    public final boolean isSafelyReplaceableBy(Node newNode) {
        return NodeUtil.isReplacementSafe(this.getParent(), this, newNode);
    }

    private void reportReplace(Node oldNode, Node newNode, CharSequence reason) {
        for (Node node = this; node != null; node = node.getParent()) {
            RootCallTarget target;
            boolean consumed = false;
            if (node instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)node)).nodeReplaced(oldNode, newNode, reason);
            } else if (node instanceof RootNode && (target = ((RootNode)node).getCallTarget()) instanceof ReplaceObserver) {
                consumed = ((ReplaceObserver)((Object)target)).nodeReplaced(oldNode, newNode, reason);
            }
            if (consumed) break;
        }
        if (TruffleOptions.TraceRewrites) {
            NodeUtil.traceRewrite(this, newNode, reason);
        }
        if (TruffleOptions.TraceASTJSON) {
            JSONHelper.dumpReplaceChild(this, newNode, reason);
        }
    }

    protected void onReplace(Node newNode, CharSequence reason) {
    }

    public final void accept(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            NodeUtil.forEachChildRecursive(this, nodeVisitor);
        }
    }

    public final Iterable<Node> getChildren() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return Node.this.getNodeClass().makeIterator(Node.this);
            }
        };
    }

    public Node copy() {
        CompilerAsserts.neverPartOfCompilation("do not call Node.copy from compiled code");
        try {
            return (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Node deepCopy() {
        return NodeUtil.deepCopyImpl(this);
    }

    public final RootNode getRootNode() {
        Node rootNode = this;
        while (rootNode.getParent() != null) {
            assert (!(rootNode instanceof RootNode)) : "root node must not have a parent";
            rootNode = rootNode.getParent();
        }
        if (rootNode instanceof RootNode) {
            return (RootNode)rootNode;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        Map<String, Object> properties = this.getDebugProperties();
        boolean hasProperties = false;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            sb.append(hasProperties ? "," : "<");
            hasProperties = true;
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (hasProperties) {
            sb.append(">");
        }
        sb.append("@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void atomic(Runnable closure) {
        Object object = this.getAtomicLock();
        synchronized (object) {
            assert (Node.enterAtomic());
            try {
                closure.run();
            }
            finally {
                assert (Node.exitAtomic());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T> T atomic(Callable<T> closure) {
        try {
            Object object = this.getAtomicLock();
            synchronized (object) {
                assert (Node.enterAtomic());
                T t = closure.call();
                return t;
                finally {
                    assert (Node.exitAtomic());
                }
            }
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final Object getAtomicLock() {
        RootNode root = this.getRootNode();
        return root == null ? GIL : root;
    }

    protected boolean isTaggedWith(Class<?> tag) {
        return false;
    }

    public String getDescription() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null) {
            return info.description();
        }
        return "";
    }

    public String getLanguage() {
        NodeInfo info = this.getClass().getAnnotation(NodeInfo.class);
        if (info != null && info.language() != null && info.language().length() > 0) {
            return info.language();
        }
        if (this.parent != null) {
            return this.parent.getLanguage();
        }
        return "";
    }

    private static boolean inAtomicBlock() {
        return IN_ATOMIC_BLOCK.get() > 0;
    }

    private static boolean enterAtomic() {
        IN_ATOMIC_BLOCK.set(IN_ATOMIC_BLOCK.get() + 1);
        return true;
    }

    private static boolean exitAtomic() {
        IN_ATOMIC_BLOCK.set(IN_ATOMIC_BLOCK.get() - 1);
        return true;
    }

    static final class AccessorNodes
    extends Accessor {
        AccessorNodes() {
        }

        @Override
        protected void onLoopCount(Node source, int iterations) {
            super.onLoopCount(source, iterations);
        }

        @Override
        protected Accessor.Nodes nodes() {
            return new AccessNodes();
        }

        static final class AccessNodes
        extends Accessor.Nodes {
            AccessNodes() {
            }

            @Override
            public Class<? extends TruffleLanguage> findLanguage(RootNode n) {
                return n.language;
            }

            @Override
            public boolean isInstrumentable(RootNode rootNode) {
                return rootNode.isInstrumentable();
            }

            @Override
            public boolean isTaggedWith(Node node, Class<?> tag) {
                return node.isTaggedWith(tag);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Child {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Children {
    }
}

