/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;

public class StringCodeRangeableWrapper
implements CodeRangeable {
    private final DynamicObject string;
    private final EncodingNodes.CheckEncodingNode checkEncodingNode;

    public StringCodeRangeableWrapper(DynamicObject string, EncodingNodes.CheckEncodingNode checkEncodingNode) {
        assert (RubyGuards.isRubyString(string));
        this.string = string;
        this.checkEncodingNode = checkEncodingNode;
    }

    public int getCodeRange() {
        return StringOperations.getCodeRange(this.string).toInt();
    }

    public int scanForCodeRange() {
        return StringOperations.codeRange(this.string).toInt();
    }

    public boolean isCodeRangeValid() {
        return StringOperations.isCodeRangeValid(this.string);
    }

    public void setCodeRange(int newCodeRange) {
        StringOperations.setCodeRange(this.string, newCodeRange);
    }

    public final void clearCodeRange() {
        StringOperations.clearCodeRange(this.string);
    }

    public final void keepCodeRange() {
        StringOperations.keepCodeRange(this.string);
    }

    public final void modify() {
    }

    public final void modify(int length) {
    }

    public final void modifyAndKeepCodeRange() {
        StringOperations.keepCodeRange(this.string);
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return this.checkEncodingNode.executeCheckEncoding(this.string, ((StringCodeRangeableWrapper)other).string);
    }

    public ByteList getByteList() {
        throw new RuntimeException("Replace with read-only call or rope update for String.");
    }

    public DynamicObject getString() {
        return this.string;
    }
}

