/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayHelpers;

public class ArgumentDescriptorUtils {
    public static DynamicObject argumentDescriptorsToParameters(RubyContext context, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        Object[] params = new Object[argsDesc.length];
        for (int i = 0; i < argsDesc.length; ++i) {
            params[i] = ArgumentDescriptorUtils.toArray(context, argsDesc[i], isLambda);
        }
        return ArrayHelpers.createArray(context, params, params.length);
    }

    public static DynamicObject toArray(RubyContext context, ArgumentDescriptor argDesc, boolean isLambda) {
        if (argDesc.type == ArgumentType.req && !isLambda) {
            return ArgumentDescriptorUtils.toArray(context, ArgumentType.opt, argDesc.name);
        }
        return ArgumentDescriptorUtils.toArray(context, argDesc.type, argDesc.name);
    }

    public static DynamicObject toArray(RubyContext context, ArgumentType argType, String name) {
        Object[] store = argType.anonymous || name == null ? new Object[]{context.getSymbolTable().getSymbol(argType.symbolicName)} : new Object[]{context.getSymbolTable().getSymbol(argType.symbolicName), context.getSymbolTable().getSymbol(name)};
        return ArrayHelpers.createArray(context, store, store.length);
    }
}

