/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.language.loader.SourceLoader;

public class SourceCache {
    private final SourceLoader loader;
    private final Map<String, Source> sources = new HashMap<String, Source>();

    public SourceCache(SourceLoader loader) {
        this.loader = loader;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized Source getSource(String canonicalPath) throws IOException {
        Source source = this.sources.get(canonicalPath);
        if (source == null) {
            source = this.loader.load(canonicalPath);
            this.sources.put(canonicalPath, source);
        }
        return source;
    }

    public synchronized Source getBestSourceFuzzily(String fuzzyPath) {
        ArrayList<Map.Entry<String, Source>> matches = new ArrayList<Map.Entry<String, Source>>(this.sources.entrySet());
        Collections.sort(matches, (a, b) -> Integer.compare(this.lengthOfCommonPrefix(fuzzyPath, (String)b.getKey()), this.lengthOfCommonPrefix(fuzzyPath, (String)a.getKey())));
        if (matches.isEmpty()) {
            return null;
        }
        return (Source)((Map.Entry)matches.get(0)).getValue();
    }

    private int lengthOfCommonPrefix(String a, String b) {
        int n;
        for (n = 0; n < a.length() && n < b.length() && a.charAt(a.length() - n - 1) == b.charAt(b.length() - n - 1); ++n) {
        }
        return n;
    }
}

