/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class StreamPosTokenizer {
    private Reader reader = null;
    private int readpos = 0;
    private int startpos = -1;
    private int endpos = -1;
    private Vector<Integer> unread = new Vector();
    private char[] buf = new char[20];
    private int peekc = Integer.MAX_VALUE;
    private static final int NEED_CHAR = Integer.MAX_VALUE;
    private static final int SKIP_LF = 0x7FFFFFFE;
    private boolean pushedBack;
    private boolean forceLower;
    private int lineno = 1;
    private boolean eolIsSignificantP = false;
    private boolean slashSlashCommentsP = false;
    private boolean slashStarCommentsP = false;
    private char[] slashSlash = new char[]{'/', '/'};
    private char[] slashStar = new char[]{'/', '*'};
    private char[] starSlash = new char[]{'*', '/'};
    private byte[] ctype = new byte[256];
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_DIGIT = 2;
    private static final byte CT_ALPHA = 4;
    private static final byte CT_QUOTE = 8;
    private static final byte CT_COMMENT = 16;
    private boolean isParseHexNumbers = false;
    private boolean isParseExponents = false;
    public int ttype = -4;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    private static final int TT_NOTHING = -4;
    public String sval;
    public double nval;

    public StreamPosTokenizer() {
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    public StreamPosTokenizer(Reader reader) {
        this();
        if (reader == null) {
            throw new NullPointerException();
        }
        this.reader = reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
        this.readpos = 0;
        this.unread.clear();
        this.peekc = Integer.MAX_VALUE;
        this.pushedBack = false;
        this.forceLower = false;
        this.lineno = 0;
        this.endpos = -1;
        this.startpos = -1;
        this.ttype = -4;
    }

    public void resetSyntax() {
        int n = this.ctype.length;
        while (--n >= 0) {
            this.ctype[n] = 0;
        }
    }

    public void wordChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            int n3 = n++;
            this.ctype[n3] = (byte)(this.ctype[n3] | 4);
        }
    }

    public void whitespaceChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            this.ctype[n++] = 1;
        }
    }

    public void ordinaryChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.ctype.length) {
            n2 = this.ctype.length - 1;
        }
        while (n <= n2) {
            this.ctype[n++] = 0;
        }
    }

    public void ordinaryChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 0;
        }
    }

    public void commentChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 16;
        }
    }

    public void quoteChar(int n) {
        if (n >= 0 && n < this.ctype.length) {
            this.ctype[n] = 8;
        }
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            this.ctype[n2] = (byte)(this.ctype[n2] | 2);
        }
        this.ctype[46] = (byte)(this.ctype[46] | 2);
        this.ctype[45] = (byte)(this.ctype[45] | 2);
    }

    public void parsePlusAsNumber() {
        this.ctype[43] = (byte)(this.ctype[43] | 2);
    }

    public void parseHexNumbers() {
        this.parseNumbers();
        this.isParseHexNumbers = true;
    }

    public void parseExponents() {
        this.parseNumbers();
        this.isParseExponents = true;
    }

    public void eolIsSignificant(boolean bl) {
        this.eolIsSignificantP = bl;
    }

    public void slashStarComments(boolean bl) {
        this.slashStarCommentsP = bl;
    }

    public void slashSlashComments(boolean bl) {
        this.slashSlashCommentsP = bl;
    }

    public void lowerCaseMode(boolean bl) {
        this.forceLower = bl;
    }

    private int read() throws IOException {
        int n;
        if (this.unread.size() > 0) {
            n = this.unread.lastElement();
            this.unread.removeElementAt(this.unread.size() - 1);
        } else {
            n = this.reader.read();
        }
        if (n != -1) {
            ++this.readpos;
        }
        return n;
    }

    private void unread(int n) {
        this.unread.addElement(new Integer(n));
        --this.readpos;
    }

    public int nextToken() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        byte[] byArray;
        block82: {
            block85: {
                block83: {
                    block84: {
                        if (this.pushedBack) {
                            this.pushedBack = false;
                            return this.ttype;
                        }
                        byArray = this.ctype;
                        this.sval = null;
                        n4 = this.peekc;
                        if (n4 < 0) {
                            n4 = Integer.MAX_VALUE;
                        }
                        if (n4 == 0x7FFFFFFE) {
                            n4 = this.read();
                            if (n4 < 0) {
                                this.startpos = this.endpos = this.readpos - 1;
                                this.ttype = -1;
                                return -1;
                            }
                            if (n4 == 10) {
                                n4 = Integer.MAX_VALUE;
                            }
                        }
                        if (n4 == Integer.MAX_VALUE && (n4 = this.read()) < 0) {
                            this.startpos = this.endpos = this.readpos - 1;
                            this.ttype = -1;
                            return -1;
                        }
                        this.ttype = n4;
                        this.peekc = Integer.MAX_VALUE;
                        int n5 = n3 = n4 < 256 ? byArray[n4] : 4;
                        while ((n3 & 1) != 0) {
                            if (n4 == 13) {
                                ++this.lineno;
                                if (this.eolIsSignificantP) {
                                    this.peekc = 0x7FFFFFFE;
                                    this.startpos = this.endpos = this.readpos - 1;
                                    this.ttype = 10;
                                    return 10;
                                }
                                n4 = this.read();
                                if (n4 == 10) {
                                    n4 = this.read();
                                }
                            } else {
                                if (n4 == 10) {
                                    ++this.lineno;
                                    if (this.eolIsSignificantP) {
                                        this.startpos = this.endpos = this.readpos - 1;
                                        this.ttype = 10;
                                        return 10;
                                    }
                                }
                                n4 = this.read();
                            }
                            if (n4 < 0) {
                                this.startpos = this.endpos = this.readpos;
                                this.ttype = -1;
                                return -1;
                            }
                            n3 = n4 < 256 ? byArray[n4] : 4;
                        }
                        this.startpos = this.readpos - 1;
                        if ((n3 & 2) != 0 && n4 == 48 && this.isParseHexNumbers) {
                            n4 = this.read();
                            if (n4 == 120) {
                                long l = 0L;
                                for (int i = 0; i < 16; ++i) {
                                    n4 = this.read();
                                    if (n4 >= 48 && n4 <= 57) {
                                        l = l << 4 | (long)(n4 - 48);
                                        continue;
                                    }
                                    if (n4 >= 65 && n4 <= 70) {
                                        l = l << 4 | (long)(n4 - 65 + 10);
                                        continue;
                                    }
                                    if (n4 >= 97 && n4 <= 102) {
                                        l = l << 4 | (long)(n4 - 97 + 10);
                                        continue;
                                    }
                                    this.unread(n4);
                                    if (i == 0) {
                                        this.sval = "0x";
                                        this.endpos = this.readpos - 1;
                                        this.ttype = -3;
                                        return -3;
                                    }
                                    this.nval = l;
                                    this.endpos = this.readpos - 1;
                                    this.ttype = -2;
                                    return -2;
                                }
                                this.nval = l;
                                this.endpos = this.readpos - 1;
                                this.ttype = -2;
                                return -2;
                            }
                            this.unread(n4);
                            n4 = 48;
                        }
                        if ((n3 & 2) == 0) break block82;
                        n2 = 0;
                        n = 0;
                        if (n4 != 45) break block83;
                        n4 = this.read();
                        if (n4 == 46 || n4 >= 48 && n4 <= 57) break block84;
                        this.peekc = n4;
                        this.unread(n4);
                        n4 = 45;
                        break block82;
                    }
                    n = 1;
                    break block85;
                }
                if (n4 == 43) {
                    n4 = this.read();
                    if (n4 != 46 && (n4 < 48 || n4 > 57)) {
                        this.peekc = n4;
                        this.endpos = this.readpos - 1;
                        this.ttype = 45;
                        return 45;
                    }
                    n = 0;
                }
            }
            double d = 0.0;
            int n6 = 0;
            int n7 = 0;
            while (true) {
                if (n4 == 46 && n7 == 0) {
                    n7 = 1;
                } else {
                    if (48 > n4 || n4 > 57) break;
                    ++n2;
                    d = d * 10.0 + (double)(n4 - 48);
                    n6 += n7;
                }
                n4 = this.read();
            }
            this.peekc = n4;
            if (n6 != 0) {
                double d2 = 10.0;
                --n6;
                while (n6 > 0) {
                    d2 *= 10.0;
                    --n6;
                }
                d /= d2;
            }
            this.nval = n != 0 ? -d : d;
            int n8 = this.endpos = n4 == -1 ? this.readpos - 1 : this.readpos - 2;
            if (n2 == 0) {
                this.unread(n4);
                if (n != 0) {
                    this.unread(46);
                    n4 = 45;
                } else {
                    this.read();
                    n4 = 46;
                }
            } else {
                if (this.isParseExponents && (n4 == 69 || n4 == 101)) {
                    n4 = this.read();
                    n2 = 0;
                    n = 0;
                    if (n4 == 45) {
                        n4 = this.read();
                        if (n4 < 48 || n4 > 57) {
                            this.unread(n4);
                            this.unread(69);
                            this.ttype = -2;
                            return -2;
                        }
                        n = 1;
                    }
                    d = 0.0;
                    n6 = 0;
                    while (48 <= n4 && n4 <= 57) {
                        ++n2;
                        d = d * 10.0 + (double)(n4 - 48);
                        n4 = this.read();
                    }
                    this.peekc = n4;
                    this.nval *= Math.pow(10.0, n != 0 ? -d : d);
                }
                this.ttype = -2;
                return -2;
            }
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
            do {
                if (n2 >= this.buf.length) {
                    char[] cArray = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                }
                this.buf[n2++] = (char)n4;
            } while (((n3 = (n4 = this.read()) < 0 ? 1 : (n4 < 256 ? byArray[n4] : 4)) & 6) != 0);
            this.peekc = n4;
            this.sval = String.copyValueOf(this.buf, 0, n2);
            if (this.forceLower) {
                this.sval = this.sval.toLowerCase();
            }
            this.endpos = n4 == -1 ? this.readpos - 1 : this.readpos - 2;
            this.ttype = -3;
            return -3;
        }
        if ((n3 & 8) != 0) {
            this.ttype = n4;
            n2 = 0;
            n = this.read();
            while (n >= 0 && n != this.ttype && n != 10 && n != 13) {
                if (n == 92) {
                    int n9 = n4 = this.read();
                    if (n4 >= 48 && n4 <= 55) {
                        n4 -= 48;
                        int n10 = this.read();
                        if (48 <= n10 && n10 <= 55) {
                            n4 = (n4 << 3) + (n10 - 48);
                            n10 = this.read();
                            if (48 <= n10 && n10 <= 55 && n9 <= 51) {
                                n4 = (n4 << 3) + (n10 - 48);
                                n = this.read();
                            } else {
                                n = n10;
                            }
                        } else {
                            n = n10;
                        }
                    } else {
                        switch (n4) {
                            case 97: {
                                n4 = 7;
                                break;
                            }
                            case 98: {
                                n4 = 8;
                                break;
                            }
                            case 102: {
                                n4 = 12;
                                break;
                            }
                            case 110: {
                                n4 = 10;
                                break;
                            }
                            case 114: {
                                n4 = 13;
                                break;
                            }
                            case 116: {
                                n4 = 9;
                                break;
                            }
                            case 118: {
                                n4 = 11;
                            }
                        }
                        n = this.read();
                    }
                } else {
                    n4 = n;
                    n = this.read();
                }
                if (n2 >= this.buf.length) {
                    char[] cArray = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                }
                this.buf[n2++] = (char)n4;
            }
            this.peekc = n == this.ttype ? Integer.MAX_VALUE : n;
            this.sval = String.copyValueOf(this.buf, 0, n2);
            this.endpos = this.readpos - 2;
            return this.ttype;
        }
        if (this.slashSlashCommentsP && n4 == this.slashSlash[0] || this.slashStarCommentsP && n4 == this.slashStar[0]) {
            if (n4 == this.slashStar[0] && this.slashStar.length == 1) {
                while ((n4 = this.read()) != this.starSlash[0]) {
                    if (n4 == 13) {
                        ++this.lineno;
                        n4 = this.read();
                        if (n4 == 10) {
                            n4 = this.read();
                        }
                    } else if (n4 == 10) {
                        ++this.lineno;
                        n4 = this.read();
                    }
                    if (n4 >= 0) continue;
                    this.endpos = this.readpos;
                    this.ttype = -1;
                    return -1;
                }
                return this.nextToken();
            }
            if (n4 == this.slashSlash[0] && this.slashSlash.length == 1) {
                while ((n4 = this.read()) != 10 && n4 != 13 && n4 >= 0) {
                }
                this.peekc = n4;
                return this.nextToken();
            }
            n4 = this.read();
            if (n4 == this.slashStar[1] && this.slashStarCommentsP) {
                n2 = 0;
                while ((n4 = this.read()) != this.starSlash[1] || n2 != this.starSlash[0]) {
                    if (n4 == 13) {
                        ++this.lineno;
                        n4 = this.read();
                        if (n4 == 10) {
                            n4 = this.read();
                        }
                    } else if (n4 == 10) {
                        ++this.lineno;
                        n4 = this.read();
                    }
                    if (n4 < 0) {
                        this.endpos = this.readpos;
                        this.ttype = -1;
                        return -1;
                    }
                    n2 = n4;
                }
                return this.nextToken();
            }
            if (n4 == this.slashSlash[1] && this.slashSlashCommentsP) {
                while ((n4 = this.read()) != 10 && n4 != 13 && n4 >= 0) {
                }
                this.peekc = n4;
                return this.nextToken();
            }
            if ((byArray[this.slashSlash[0]] & 0x10) != 0) {
                while ((n4 = this.read()) != 10 && n4 != 13 && n4 >= 0) {
                }
                this.peekc = n4;
                return this.nextToken();
            }
            this.peekc = n4;
            this.endpos = this.readpos - 2;
            this.ttype = this.slashSlash[0];
            return this.ttype;
        }
        if ((n3 & 0x10) != 0) {
            while ((n4 = this.read()) != 10 && n4 != 13 && n4 >= 0) {
            }
            this.peekc = n4;
            ++this.lineno;
            return this.nextToken();
        }
        this.endpos = this.readpos - 1;
        this.ttype = n4;
        return this.ttype;
    }

    public int nextChar() throws IOException {
        if (this.pushedBack) {
            throw new IllegalStateException("can't read char when a token has been pushed back");
        }
        if (this.peekc == Integer.MAX_VALUE) {
            return this.read();
        }
        int n = this.peekc;
        this.peekc = Integer.MAX_VALUE;
        return n;
    }

    public void pushCharBack(int n) throws IOException {
        if (this.pushedBack) {
            throw new IllegalStateException("can't push back char when a token has been pushed back");
        }
        if (this.peekc == Integer.MAX_VALUE) {
            this.unread(n);
        } else {
            this.unread(this.peekc);
            this.peekc = Integer.MAX_VALUE;
            this.unread(n);
        }
    }

    public void setSlashStarTokens(String string, String string2) {
        if (string.length() != string2.length()) {
            throw new IllegalArgumentException("SlashStar and StarSlash tokens must be of same length: '" + string + "' '" + string2 + "'");
        }
        if (string.length() < 1 || string.length() > 2) {
            throw new IllegalArgumentException("SlashStar and StarSlash tokens must be of length 1 or 2: '" + string + "' '" + string2 + "'");
        }
        this.slashStar = string.toCharArray();
        this.starSlash = string2.toCharArray();
        this.commentChar(this.slashStar[0]);
    }

    public void setSlashSlashToken(String string) {
        if (string.length() < 1 || string.length() > 2) {
            throw new IllegalArgumentException("SlashSlash token must be of length 1 or 2: '" + string + "'");
        }
        this.slashSlash = string.toCharArray();
        this.commentChar(this.slashSlash[0]);
    }

    public void pushBack() {
        if (this.ttype != -4) {
            this.pushedBack = true;
        }
    }

    public int lineno() {
        return this.lineno;
    }

    public int getStartPosition() {
        return this.startpos;
    }

    public void setStartPosition(int n) {
        this.startpos = n;
    }

    public int getEndPosition() {
        return this.endpos;
    }

    public void consumeGreedy(String string) {
        if (string.length() < this.sval.length()) {
            this.pushBack();
            this.setStartPosition(this.getStartPosition() + string.length());
            this.sval = this.sval.substring(string.length());
        }
    }

    public String toString() {
        String string;
        switch (this.ttype) {
            case -1: {
                string = "EOF";
                break;
            }
            case 10: {
                string = "EOL";
                break;
            }
            case -3: {
                string = this.sval;
                break;
            }
            case -2: {
                string = "n=" + this.nval;
                break;
            }
            case -4: {
                string = "NOTHING";
                break;
            }
            default: {
                char[] cArray = new char[3];
                cArray[2] = 39;
                cArray[0] = 39;
                cArray[1] = (char)this.ttype;
                string = new String(cArray);
                break;
            }
        }
        return "Token[" + string + "], line " + this.lineno;
    }
}

