/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.ListSpecification;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.util.AttributeMap;

public class DefaultLayoutContext
implements LayoutContext,
Cloneable {
    private static Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private BackgroundSpecification backgroundSpecification;
    private FontSpecification fontSpecification;
    private ContentSpecification contentSpecification;
    private ListSpecification listSpecification;
    private LayoutStyleImpl style;
    private ContextId contextId;
    private String namespace;
    private String tagName;
    private AttributeMap attributeMap;
    private String pseudoElement;
    private boolean derived;
    private Map counters;
    private Map strings;

    public DefaultLayoutContext(ContextId contextId, String string, String string2, String string3, AttributeMap attributeMap) {
        this.pseudoElement = string3;
        if (contextId == null) {
            throw new NullPointerException();
        }
        if (attributeMap == null) {
            throw new NullPointerException();
        }
        this.namespace = string;
        this.tagName = string2;
        this.attributeMap = attributeMap;
        this.contextId = contextId;
        this.style = new LayoutStyleImpl();
        this.fontSpecification = new FontSpecification(this.style);
        this.backgroundSpecification = new BackgroundSpecification();
        this.contentSpecification = new ContentSpecification();
        this.listSpecification = new ListSpecification();
        this.strings = EMPTY_MAP;
        this.counters = EMPTY_MAP;
    }

    public String getPseudoElement() {
        return this.pseudoElement;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTagName() {
        return this.tagName;
    }

    public AttributeMap getAttributes() {
        return this.attributeMap;
    }

    public BackgroundSpecification getBackgroundSpecification() {
        return this.backgroundSpecification;
    }

    public FontSpecification getFontSpecification() {
        return this.fontSpecification;
    }

    public ContentSpecification getContentSpecification() {
        return this.contentSpecification;
    }

    public ListSpecification getListSpecification() {
        return this.listSpecification;
    }

    public void setValue(StyleKey styleKey, CSSValue cSSValue) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        this.style.setValue(styleKey, cSSValue);
    }

    public CSSValue getValue(StyleKey styleKey) {
        return this.style.getValue(styleKey);
    }

    public LayoutStyle getStyle() {
        return this.style;
    }

    public ContextId getContextId() {
        return this.contextId;
    }

    public Locale getLanguage() {
        return Locale.getDefault();
    }

    public boolean isPseudoElement() {
        return this.pseudoElement != null;
    }

    public Object clone() {
        try {
            DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)super.clone();
            defaultLayoutContext.derived = true;
            return defaultLayoutContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Invalid implementation: Clone not supported.");
        }
    }

    public LayoutContext derive() {
        DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)this.clone();
        defaultLayoutContext.tagName = this.tagName + '*';
        return defaultLayoutContext;
    }

    public void dispose() {
        this.style.dispose();
    }

    public boolean copyFrom(LayoutStyle layoutStyle) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        return this.style.copyFrom(layoutStyle);
    }

    public Map getCounters() {
        return this.counters;
    }

    public Map getStrings() {
        return this.strings;
    }

    public LayoutContext detach(Map map, Map map2) {
        DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)this.derive();
        if (map2 != null) {
            defaultLayoutContext.strings = Collections.unmodifiableMap(map2);
        }
        if (map != null) {
            defaultLayoutContext.counters = Collections.unmodifiableMap(map);
        }
        return defaultLayoutContext;
    }
}

