/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.normalizer.generator;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.normalizer.generator.ContentGenerator;
import org.jfree.layouting.renderer.Renderer;

public class DefaultContentGenerator
implements ContentGenerator {
    private Renderer renderer;

    public DefaultContentGenerator(LayoutProcess layoutProcess) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.renderer = layoutProcess.getOutputProcessor().createRenderer(layoutProcess);
    }

    protected DefaultContentGenerator(Renderer renderer) {
        this.renderer = renderer;
    }

    public void startedDocument(PageContext pageContext) {
        this.renderer.startedDocument(pageContext);
    }

    public void startedFlow(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedFlow(layoutContext);
    }

    public void startedTable(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTable(layoutContext);
    }

    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableColumnGroup(layoutContext);
    }

    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableColumn(layoutContext);
    }

    public void startedTableSection(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableSection(layoutContext);
    }

    public void startedTableRow(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableRow(layoutContext);
    }

    public void startedTableCell(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableCell(layoutContext);
    }

    public void startedBlock(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedBlock(layoutContext);
    }

    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedMarker(layoutContext);
    }

    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedRootInline(layoutContext);
    }

    public void startedInline(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedInline(layoutContext);
    }

    public void addContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        this.renderer.addContent(layoutContext, contentToken);
    }

    public void finishedInline() throws NormalizationException {
        this.renderer.finishedInline();
    }

    public void finishedMarker() throws NormalizationException {
        this.renderer.finishedMarker();
    }

    public void finishedRootInline() throws NormalizationException {
        this.renderer.finishedRootInline();
    }

    public void finishedBlock() throws NormalizationException {
        this.renderer.finishedBlock();
    }

    public void finishedTableCell() throws NormalizationException {
        this.renderer.finishedTableCell();
    }

    public void finishedTableRow() throws NormalizationException {
        this.renderer.finishedTableRow();
    }

    public void finishedTableSection() throws NormalizationException {
        this.renderer.finishedTableSection();
    }

    public void finishedTableColumn() throws NormalizationException {
        this.renderer.finishedTableColumn();
    }

    public void finishedTableColumnGroup() throws NormalizationException {
        this.renderer.finishedTableColumnGroup();
    }

    public void finishedTable() throws NormalizationException {
        this.renderer.finishedTable();
    }

    public void finishedFlow() throws NormalizationException {
        this.renderer.finishedFlow();
    }

    public void finishedDocument() throws NormalizationException {
        this.renderer.finishedDocument();
    }

    public void handlePageBreak(PageContext pageContext) {
        this.renderer.handlePageBreak(pageContext);
    }

    public void startedPassThrough(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedPassThrough(layoutContext);
    }

    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) throws NormalizationException {
        this.renderer.addPassThroughContent(layoutContext, contentToken);
    }

    public void finishedPassThrough() throws NormalizationException {
        this.renderer.finishedPassThrough();
    }

    public State saveState() throws StateException {
        DefaultContentGeneratorState defaultContentGeneratorState = new DefaultContentGeneratorState();
        defaultContentGeneratorState.setRendererState(this.renderer.saveState());
        return defaultContentGeneratorState;
    }

    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        this.renderer.startedTableCaption(layoutContext);
    }

    public void finishedTableCaption() throws NormalizationException {
        this.renderer.finishedTableCaption();
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    private static class DefaultContentGeneratorState
    implements State {
        private State rendererState;

        private DefaultContentGeneratorState() {
        }

        public State getRendererState() {
            return this.rendererState;
        }

        public void setRendererState(State state) {
            this.rendererState = state;
        }

        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            return new DefaultContentGenerator((Renderer)this.rendererState.restore(layoutProcess));
        }
    }
}

