/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.LanguageLibraryProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public abstract class JavaProjectInitDescriptor
extends LanguageLibraryProjectInitDescriptor {
    private final DocumentationRegistry documentationRegistry;

    public JavaProjectInitDescriptor(TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider, ProjectInitDescriptor globalSettingsDescriptor, DocumentationRegistry documentationRegistry) {
        super("java", templateOperationFactory, fileResolver, libraryVersionProvider, globalSettingsDescriptor);
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public void generate(BuildInitTestFramework testFramework) {
        this.globalSettingsDescriptor.generate(testFramework);
        BuildScriptBuilder buildScriptBuilder = new BuildScriptBuilder(this.fileResolver.resolve((Object)"build.gradle")).fileComment("This generated file contains a sample Java project to get you started.").fileComment("For more details take a look at the Java Quickstart chapter in the Gradle").fileComment("user guide available at " + this.documentationRegistry.getDocumentationFor("tutorial_java_projects")).plugin("Apply the java plugin to add support for Java", "java").dependency("The production code uses Guava", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
        this.configureBuildScript(buildScriptBuilder);
        this.addTestFramework(testFramework, buildScriptBuilder);
        buildScriptBuilder.create().generate();
        TemplateOperation javaSourceTemplate = this.sourceTemplateOperation();
        this.whenNoSourcesAvailable(javaSourceTemplate, this.testTemplateOperation(testFramework)).generate();
    }

    private void addTestFramework(BuildInitTestFramework testFramework, BuildScriptBuilder buildScriptBuilder) {
        switch (testFramework) {
            case SPOCK: {
                buildScriptBuilder.plugin("Apply the groovy plugin to also add support for Groovy (needed for Spock)", "groovy").testCompileDependency("Use the latest Groovy version for Spock testing", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testCompileDependency("Use the awesome Spock testing and specification framework even with Java", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
                break;
            }
            case TESTNG: {
                buildScriptBuilder.testCompileDependency("Use TestNG framework, also requires calling test.useTestNG() below", "org.testng:testng:" + this.libraryVersionProvider.getVersion("testng")).configuration("Use TestNG for unit tests", "test.useTestNG()");
                break;
            }
            default: {
                buildScriptBuilder.testCompileDependency("Use JUnit test framework", "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
            }
        }
    }

    protected void configureBuildScript(BuildScriptBuilder buildScriptBuilder) {
    }

    protected abstract TemplateOperation sourceTemplateOperation();

    protected abstract TemplateOperation testTemplateOperation(BuildInitTestFramework var1);

    @Override
    public boolean supports(BuildInitTestFramework testFramework) {
        return testFramework == BuildInitTestFramework.SPOCK || testFramework == BuildInitTestFramework.TESTNG;
    }
}

