/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.internal.changedetection.state.CacheCapSizer;
import org.gradle.api.internal.changedetection.state.InMemoryDecoratedCache;
import org.gradle.api.internal.changedetection.state.LoggingEvictionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.AsyncCacheAccess;
import org.gradle.cache.internal.AsyncCacheAccessDecoratedCache;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.cache.internal.CrossProcessCacheAccess;
import org.gradle.cache.internal.CrossProcessSynchronizingCache;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTaskArtifactCache
implements CacheDecorator {
    private static final Logger LOG = Logging.getLogger(InMemoryTaskArtifactCache.class);
    private final Cache<String, Cache<Object, Object>> cache;
    private final Map<String, AtomicReference<FileLock.State>> fileLockStates = new HashMap<String, AtomicReference<FileLock.State>>();
    private final CacheCapSizer cacheCapSizer;

    public InMemoryTaskArtifactCache() {
        this(new CacheCapSizer());
    }

    private InMemoryTaskArtifactCache(CacheCapSizer cacheCapSizer) {
        this.cacheCapSizer = cacheCapSizer;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)(cacheCapSizer.getNumberOfCaches() * 2));
        this.cache = cacheBuilder.build();
    }

    @Override
    public synchronized <K, V> MultiProcessSafePersistentIndexedCache<K, V> decorate(String cacheId, String cacheName, MultiProcessSafePersistentIndexedCache<K, V> persistentCache, CrossProcessCacheAccess crossProcessCacheAccess, AsyncCacheAccess asyncCacheAccess) {
        AsyncCacheAccessDecoratedCache<K, V> asyncCache = new AsyncCacheAccessDecoratedCache<K, V>(asyncCacheAccess, persistentCache);
        MultiProcessSafeAsyncPersistentIndexedCache<K, V> memCache = this.applyInMemoryCaching(cacheId, cacheName, asyncCache);
        return new CrossProcessSynchronizingCache<K, V>(memCache, crossProcessCacheAccess);
    }

    protected <K, V> MultiProcessSafeAsyncPersistentIndexedCache<K, V> applyInMemoryCaching(String cacheId, String cacheName, MultiProcessSafeAsyncPersistentIndexedCache<K, V> backingCache) {
        Cache<Object, Object> inMemoryCache = this.createInMemoryCache(cacheId, cacheName);
        AtomicReference<FileLock.State> fileLockStateReference = this.getFileLockStateReference(cacheId);
        return new InMemoryDecoratedCache<K, V>(backingCache, inMemoryCache, cacheId, fileLockStateReference);
    }

    private AtomicReference<FileLock.State> getFileLockStateReference(String cacheId) {
        AtomicReference<FileLock.State> fileLockStateReference = this.fileLockStates.get(cacheId);
        if (fileLockStateReference == null) {
            fileLockStateReference = new AtomicReference<Object>(null);
            this.fileLockStates.put(cacheId, fileLockStateReference);
        }
        return fileLockStateReference;
    }

    private Cache<Object, Object> createInMemoryCache(String cacheId, String cacheName) {
        Cache inMemoryCache = (Cache)this.cache.getIfPresent((Object)cacheId);
        if (inMemoryCache != null) {
            LOG.info("In-memory cache of {}: Size{{}}, {}", new Object[]{cacheId, inMemoryCache.size(), inMemoryCache.stats()});
        } else {
            Integer maxSize = this.cacheCapSizer.getMaxSize(cacheName);
            assert (maxSize != null) : "Unknown cache.";
            LOG.debug("Creating In-memory cache of {}: MaxSize{{}}", (Object)cacheId, (Object)maxSize);
            LoggingEvictionListener evictionListener = new LoggingEvictionListener(cacheId, maxSize);
            CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)maxSize.intValue()).recordStats().removalListener((RemovalListener)evictionListener);
            inMemoryCache = cacheBuilder.build();
            evictionListener.setCache((Cache<Object, Object>)inMemoryCache);
            this.cache.put((Object)cacheId, (Object)inMemoryCache);
        }
        return inMemoryCache;
    }

    public void invalidateAll() {
        for (Cache subcache : this.cache.asMap().values()) {
            subcache.invalidateAll();
        }
    }
}

