/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentIdentifierSerializer
implements Serializer<ComponentIdentifier> {
    private final BuildIdentifierSerializer buildIdentifierSerializer = new BuildIdentifierSerializer();

    public ComponentIdentifier read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.BUILD.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            return new DefaultProjectComponentIdentifier(buildIdentifier, decoder.readString());
        }
        if (Implementation.MODULE.getId() == id) {
            return new DefaultModuleComponentIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryBinaryIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
        }
        throw new IllegalArgumentException("Unable to find component identifier type with id: " + id);
    }

    public void write(Encoder encoder, ComponentIdentifier value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component identifier may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)value;
            encoder.writeString((CharSequence)moduleComponentIdentifier.getGroup());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getModule());
            encoder.writeString((CharSequence)moduleComponentIdentifier.getVersion());
        } else if (implementation == Implementation.BUILD) {
            ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
            BuildIdentifier build = projectComponentIdentifier.getBuild();
            this.buildIdentifierSerializer.write(encoder, build);
            encoder.writeString((CharSequence)projectComponentIdentifier.getProjectPath());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryBinaryIdentifier libraryIdentifier = (LibraryBinaryIdentifier)value;
            encoder.writeString((CharSequence)libraryIdentifier.getProjectPath());
            encoder.writeString((CharSequence)libraryIdentifier.getLibraryName());
            encoder.writeString((CharSequence)libraryIdentifier.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private Implementation resolveImplementation(ComponentIdentifier value) {
        Implementation implementation;
        if (value instanceof ModuleComponentIdentifier) {
            implementation = Implementation.MODULE;
        } else if (value instanceof ProjectComponentIdentifier) {
            implementation = Implementation.BUILD;
        } else if (value instanceof LibraryBinaryIdentifier) {
            implementation = Implementation.LIBRARY;
        } else {
            throw new IllegalArgumentException("Unsupported component identifier class: " + value.getClass());
        }
        return implementation;
    }

    private static enum Implementation {
        MODULE(1),
        BUILD(2),
        LIBRARY(3);

        private final byte id;

        private Implementation(byte id) {
            this.id = id;
        }

        private byte getId() {
            return this.id;
        }
    }
}

