/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.UnknownFileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiFileImplUtil {
    private PsiFileImplUtil() {
    }

    public static PsiFile setName(@NotNull PsiFile file2, @NotNull String newName2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil", "setName"));
        }
        if (newName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil", "setName"));
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        try {
            FileDocumentManager fdm;
            Document doc;
            FileType newFileType = FileTypeRegistry.getInstance().getFileTypeByFileName(newName2);
            if ((UnknownFileType.INSTANCE.equals(newFileType) || newFileType.isBinary()) && (doc = (fdm = FileDocumentManager.getInstance()).getCachedDocument(vFile)) != null) {
                fdm.saveDocumentAsIs(doc);
            }
            vFile.rename(manager, newName2);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
        return file2.getViewProvider().isPhysical() ? manager.findFile(vFile) : file2;
    }

    public static void checkSetName(@NotNull PsiFile file2, @NotNull String name2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil", "checkSetName"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil", "checkSetName"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        VirtualFile parentFile = vFile.getParent();
        if (parentFile == null) {
            return;
        }
        VirtualFile child = parentFile.findChild(name2);
        if (child != null && !child.equals(vFile)) {
            throw new IncorrectOperationException("File " + child.getPresentableUrl() + " already exists.");
        }
    }

    public static void doDelete(@NotNull PsiFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/PsiFileImplUtil", "doDelete"));
        }
        PsiManagerImpl manager = (PsiManagerImpl)file2.getManager();
        VirtualFile vFile = file2.getVirtualFile();
        try {
            vFile.delete(manager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e);
        }
    }
}

