/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public abstract class ReferenceListElement
extends CompositeElement {
    public ReferenceListElement(IElementType type2) {
        super(type2);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        if (first == last && first.getElementType() == JavaElementType.JAVA_CODE_REFERENCE && this.getLastChildNode() != null && this.getLastChildNode().getElementType() == TokenType.ERROR_ELEMENT) {
            super.deleteChildInternal(this.getLastChildNode());
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor2, before);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (first == last && first.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            LeafElement comma;
            ASTNode child;
            TreeElement element = first;
            for (child = element.getTreeNext(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreeNext()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreePrev()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        IElementType keywordType = this.getKeywordType();
        String keywordText = this.getKeywordText();
        if (this.findChildByType(keywordType) == null && this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE) != null) {
            LeafElement keyword = Factory.createSingleLeafElement(keywordType, keywordText, SharedImplUtil.findCharTableByTree(this), this.getManager());
            super.addInternal(keyword, keyword, this.getFirstChildNode(), Boolean.TRUE);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/ReferenceListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == JavaTokenType.COMMA) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && (prev.getElementType() == JavaTokenType.COMMA || prev.getElementType() == this.getKeywordType())) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    protected abstract String getKeywordText();

    protected abstract IElementType getKeywordType();
}

