/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ErrorTypesAreEqualToAnything;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002*\b\u0012\u0004\u0012\u00020\u00020\t\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\n*\b\u0012\u0004\u0012\u00020\n0\t\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0002\u00a8\u0006\f"}, d2={"asFlexibleType", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isFlexible", "", "isNullabilityFlexible", "lowerIfFlexible", "Lorg/jetbrains/kotlin/types/SimpleType;", "singleBestRepresentative", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "upperIfFlexible", "kotlin-compiler"})
public final class FlexibleTypesKt {
    public static final boolean isFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.unwrap() instanceof FlexibleType;
    }

    @NotNull
    public static final FlexibleType asFlexibleType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.FlexibleType");
        }
        return (FlexibleType)unwrappedType;
    }

    public static final boolean isNullabilityFlexible(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        UnwrappedType unwrappedType = $receiver.unwrap();
        if (!(unwrappedType instanceof FlexibleType)) {
            unwrappedType = null;
        }
        FlexibleType flexibleType = (FlexibleType)unwrappedType;
        if (flexibleType == null) {
            return false;
        }
        FlexibleType flexibility = flexibleType;
        return TypeUtils.isNullableType(flexibility.getLowerBound()) != TypeUtils.isNullableType(flexibility.getUpperBound());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KotlinType singleBestRepresentative(@NotNull Collection<? extends KotlinType> $receiver) {
        Object v1;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            if ($receiver.size() == 1) {
                return (KotlinType)CollectionsKt.first((Iterable)$receiver);
            }
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                block3: {
                    void $receiver$iv2;
                    KotlinType candidate = (KotlinType)element$iv;
                    Iterable iterable = $receiver;
                    for (Object element$iv2 : $receiver$iv2) {
                        KotlinType other = (KotlinType)element$iv2;
                        if (Intrinsics.areEqual(candidate, other) || ErrorTypesAreEqualToAnything.INSTANCE.equalTypes(candidate, other)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final TypeProjection singleBestRepresentative(@NotNull Collection<? extends TypeProjection> $receiver) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.size() == 1) {
            return (TypeProjection)CollectionsKt.first((Iterable)$receiver);
        }
        Iterable $receiver$iv = $receiver;
        Iterable iterable = $receiver$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv2;
            object = it.getProjectionKind();
            collection.add(object);
        }
        Set projectionKinds = CollectionsKt.toSet((List)destination$iv$iv2);
        if (projectionKinds.size() != 1) {
            return null;
        }
        Iterable $receiver$iv2 = $receiver;
        destination$iv$iv2 = $receiver$iv2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$a$1$map = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getType();
            collection.add(object);
        }
        KotlinType kotlinType = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv);
        if (kotlinType == null) {
            return null;
        }
        KotlinType bestType = kotlinType;
        return new TypeProjectionImpl((Variance)((Object)CollectionsKt.single(projectionKinds)), bestType);
    }

    @NotNull
    public static final SimpleType lowerIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        UnwrappedType unwrappedType = $receiver.unwrap();
        UnwrappedType $receiver2 = unwrappedType;
        UnwrappedType unwrappedType2 = $receiver2;
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getLowerBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }

    @NotNull
    public static final SimpleType upperIfFlexible(@NotNull KotlinType $receiver) {
        SimpleType simpleType2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        UnwrappedType unwrappedType = $receiver.unwrap();
        UnwrappedType $receiver2 = unwrappedType;
        UnwrappedType unwrappedType2 = $receiver2;
        if (unwrappedType2 instanceof FlexibleType) {
            simpleType2 = ((FlexibleType)$receiver2).getUpperBound();
        } else if (unwrappedType2 instanceof SimpleType) {
            simpleType2 = (SimpleType)$receiver2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType2;
    }
}

