/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import com.google.common.base.Preconditions;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.memory.MemoryInfo;

public class LowMemoryDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final MemoryInfo memoryInfo;
    protected final long memoryThresholdInBytes;
    private static final Logger LOG = Logging.getLogger(LowMemoryDaemonExpirationStrategy.class);
    public static final String EXPIRATION_REASON = "to reclaim system memory";
    public static final long MIN_THRESHOLD_BYTES = 0x18000000L;
    public static final long MAX_THRESHOLD_BYTES = 0x40000000L;

    public LowMemoryDaemonExpirationStrategy(MemoryInfo memoryInfo, double minFreeMemoryPercentage) {
        Preconditions.checkArgument((minFreeMemoryPercentage >= 0.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be >= 0");
        Preconditions.checkArgument((minFreeMemoryPercentage <= 1.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be <= 1");
        this.memoryInfo = (MemoryInfo)Preconditions.checkNotNull((Object)memoryInfo);
        this.memoryThresholdInBytes = this.normalizeThreshold((long)((double)memoryInfo.getTotalPhysicalMemory() * minFreeMemoryPercentage), 0x18000000L, 0x40000000L);
    }

    private long normalizeThreshold(long thresholdIn, long minValue, long maxValue) {
        return Math.min(maxValue, Math.max(minValue, thresholdIn));
    }

    public DaemonExpirationResult checkExpiration() {
        long freeMem = this.memoryInfo.getFreePhysicalMemory();
        if (freeMem < this.memoryThresholdInBytes) {
            LOG.info("after free system memory (" + NumberUtil.formatBytes(freeMem) + ") fell below threshold of " + NumberUtil.formatBytes(this.memoryThresholdInBytes));
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

