/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jcs.engine.AbstractCacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEventQueue<K, V>
extends AbstractCacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(CacheEventQueue.class);
    private static final ICacheEventQueue.QueueType queueType = ICacheEventQueue.QueueType.SINGLE;
    private Thread processorThread;
    private LinkedBlockingQueue<AbstractCacheEventQueue.AbstractCacheEvent> queue = new LinkedBlockingQueue();

    public CacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string) {
        this(iCacheListener, l, string, 10, 500);
    }

    public CacheEventQueue(ICacheListener<K, V> iCacheListener, long l, String string, int n, int n2) {
        this.initialize(iCacheListener, l, string, n, n2);
    }

    @Override
    public ICacheEventQueue.QueueType getQueueType() {
        return queueType;
    }

    protected void stopProcessing() {
        this.setAlive(false);
        this.processorThread = null;
    }

    @Override
    public void destroy() {
        if (this.isAlive()) {
            this.setAlive(false);
            if (log.isInfoEnabled()) {
                log.info("Destroying queue, stats =  " + this.getStatistics());
            }
            if (this.processorThread != null) {
                this.processorThread.interrupt();
                this.processorThread = null;
            }
            if (log.isInfoEnabled()) {
                log.info("Cache event queue destroyed: " + this);
            }
        } else if (log.isInfoEnabled()) {
            log.info("Destroy was called after queue was destroyed. Doing nothing. Stats =  " + this.getStatistics());
        }
    }

    @Override
    protected void put(AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent) {
        if (log.isDebugEnabled()) {
            log.debug("Event entering Queue for " + this.getCacheName() + ": " + abstractCacheEvent);
        }
        this.queue.offer(abstractCacheEvent);
        if (this.isWorking() && !this.isAlive()) {
            this.setAlive(true);
            this.processorThread = new QProcessor();
            this.processorThread.start();
            if (log.isInfoEnabled()) {
                log.info("Cache event queue created: " + this);
            }
        }
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Cache Event Queue");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Working", this.isWorking()));
        arrayList.add(new StatElement<Boolean>("Alive", this.isAlive()));
        arrayList.add(new StatElement<Boolean>("Empty", this.isEmpty()));
        arrayList.add(new StatElement<Integer>("Size", this.size()));
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    protected class QProcessor
    extends Thread {
        QProcessor() {
            super("CacheEventQueue.QProcessor-" + CacheEventQueue.this.getCacheName());
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (this.isAlive()) {
                AbstractCacheEventQueue.AbstractCacheEvent abstractCacheEvent = null;
                try {
                    abstractCacheEvent = (AbstractCacheEventQueue.AbstractCacheEvent)CacheEventQueue.this.queue.poll(CacheEventQueue.this.getWaitToDieMillis(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug("Event from queue = " + abstractCacheEvent);
                }
                if (abstractCacheEvent == null) {
                    CacheEventQueue.this.stopProcessing();
                }
                if (abstractCacheEvent == null || !CacheEventQueue.this.isWorking() || !this.isAlive()) continue;
                abstractCacheEvent.run();
            }
            if (log.isDebugEnabled()) {
                log.debug("QProcessor exiting for " + CacheEventQueue.this.getCacheName());
            }
        }
    }
}

