/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.tools.I18n;

public class Sinusoidal
extends AbstractProj {
    @Override
    public String getName() {
        return I18n.tr("Sinusoidal", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "sinu";
    }

    @Override
    public double[] project(double d, double d2) {
        if (this.spherical) {
            return new double[]{d2 * Math.cos(d), d};
        }
        double d3 = Math.sin(d);
        return new double[]{d2 * Math.cos(d) / Math.sqrt(1.0 - this.e2 * d3 * d3), this.mlfn(d, d3, Math.cos(d))};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3;
        if (this.spherical) {
            return new double[]{d2, d / Math.cos(d2)};
        }
        double d4 = this.invMlfn(d2);
        double d5 = Math.abs(d4);
        if (Math.abs(d5 - 1.5707963267948966) < 1.0E-10) {
            d3 = 0.0;
        } else if (d5 < 1.5707963267948966) {
            d5 = Math.sin(d4);
            d3 = d * Math.sqrt(1.0 - this.e2 * d5 * d5) / Math.cos(d4) % Math.PI;
        } else {
            return new double[]{0.0, 0.0};
        }
        return new double[]{d4, d3};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-90.0, -180.0, 90.0, 180.0, false);
    }
}

