/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import java.io.Serializable;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.Signature;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.DVarParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.LocalVarParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.VCallParseNode;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.truffle.parser.scope.DummyDynamicScope;
import org.jruby.truffle.parser.scope.DynamicScope;

public class StaticScope
implements Serializable {
    private static final long serialVersionUID = 3423852552352498148L;
    protected final StaticScope enclosingScope;
    private transient RubyModule cref = null;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private boolean[] namedCaptures;
    private Signature signature;
    private String file;
    private DynamicScope dummyScope;
    protected IRScopeType scopeType;
    private static final String[] NO_NAMES = new String[0];
    private Type type;
    private boolean isBlockOrEval;
    private boolean isArgumentScope;
    private long commandArgumentStack;
    private IRScope irScope;
    private RubyModule overlayModule;

    protected StaticScope(Type type, StaticScope enclosingScope, String file) {
        this(type, enclosingScope, NO_NAMES);
        this.file = file;
    }

    protected StaticScope(Type type, StaticScope enclosingScope) {
        this(type, enclosingScope, NO_NAMES);
    }

    protected StaticScope(Type type, StaticScope enclosingScope, String[] names) {
        assert (names != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names));
        this.enclosingScope = enclosingScope;
        this.variableNames = names;
        this.type = type;
        this.irScope = null;
        this.isBlockOrEval = type != Type.LOCAL;
        this.isArgumentScope = !this.isBlockOrEval;
    }

    public IRScope getIRScope() {
        return this.irScope;
    }

    public IRScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(IRScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public void setIRScope(IRScope irScope) {
        this.irScope = irScope;
        this.scopeType = irScope.getScopeType();
    }

    private static boolean namesAreInterned(String[] names) {
        for (String name : names) {
            if (name == name.intern()) continue;
            return false;
        }
        return true;
    }

    public int addVariableThisScope(String name) {
        if (name.equals("_$0")) {
            return -1;
        }
        int slot = this.exists(name);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name);
        return this.variableNames.length - 1;
    }

    public int addNamedCaptureVariable(String name) {
        int index = this.addVariableThisScope(name);
        this.growNamedCaptures(index);
        return index;
    }

    public int addVariable(String name) {
        int slot = this.isDefined(name);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name);
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames.length;
    }

    public void setVariables(String[] names) {
        assert (names != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names));
        this.variableNames = new String[names.length];
        System.arraycopy(names, 0, this.variableNames, 0, names.length);
    }

    public IRubyObject getConstantDefined(String internedName) {
        IRubyObject result = this.cref.fetchConstant(internedName);
        if (result != null) {
            return result;
        }
        return this.previousCRefScope == null ? null : this.previousCRefScope.getConstantDefinedNoObject(internedName);
    }

    public IRubyObject getConstantDefinedNoObject(String internedName) {
        if (this.previousCRefScope == null) {
            return null;
        }
        return this.getConstantDefined(internedName);
    }

    public IRubyObject getConstant(String internedName) {
        IRubyObject result = this.getConstantInner(internedName);
        return result == null ? this.cref.getConstantNoConstMissing(internedName) : result;
    }

    public IRubyObject getConstantInner(String internedName) {
        IRubyObject result = this.cref.fetchConstant(internedName);
        if (result != null) {
            return result == RubyObject.UNDEF ? this.cref.resolveUndefConstant(internedName) : result;
        }
        return this.previousCRefScope == null ? null : this.previousCRefScope.getConstantInnerNoObject(internedName);
    }

    private IRubyObject getConstantInnerNoObject(String internedName) {
        if (this.previousCRefScope == null) {
            return null;
        }
        return this.getConstantInner(internedName);
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name) {
        return this.findVariableName(name);
    }

    private int findVariableName(String name) {
        for (int i = 0; i < this.variableNames.length; ++i) {
            if (name != this.variableNames[i]) continue;
            return i;
        }
        return -1;
    }

    public int isDefined(String name) {
        return this.isDefined(name, 0);
    }

    public AssignableParseNode assign(ISourcePosition position, String name, ParseNode value) {
        return this.assign(position, name, value, this, 0);
    }

    public String[] getAllNamesInScope() {
        String[] names = this.getVariables();
        if (this.isBlockOrEval) {
            String[] ourVariables = names;
            String[] variables = this.enclosingScope.getAllNamesInScope();
            names = new String[variables.length + ourVariables.length];
            System.arraycopy(variables, 0, names, 0, variables.length);
            System.arraycopy(ourVariables, 0, names, variables.length, ourVariables.length);
        }
        return names;
    }

    public int isDefined(String name, int depth) {
        if (this.isBlockOrEval) {
            int slot = this.exists(name);
            if (slot >= 0) {
                return depth << 16 | slot;
            }
            return this.enclosingScope.isDefined(name, depth + 1);
        }
        return depth << 16 | this.exists(name);
    }

    public AssignableParseNode addAssign(ISourcePosition position, String name, ParseNode value) {
        int slot = this.addVariable(name);
        return new DAsgnParseNode(position, name, slot, value);
    }

    public AssignableParseNode assign(ISourcePosition position, String name, ParseNode value, StaticScope topScope, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DAsgnParseNode(position, name, depth << 16 | slot, value) : new LocalAsgnParseNode(position, name, depth << 16 | slot, value);
        }
        if (!this.isBlockOrEval && topScope == this) {
            slot = this.addVariable(name);
            return new LocalAsgnParseNode(position, name, slot, value);
        }
        return this.isBlockOrEval ? this.enclosingScope.assign(position, name, value, topScope, depth + 1) : topScope.addAssign(position, name, value);
    }

    public ParseNode declare(ISourcePosition position, String name, int depth) {
        int slot = this.exists(name);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DVarParseNode(position, depth << 16 | slot, name) : new LocalVarParseNode(position, depth << 16 | slot, name);
        }
        return this.isBlockOrEval ? this.enclosingScope.declare(position, name, depth + 1) : new VCallParseNode(position, name);
    }

    public ParseNode declare(ISourcePosition position, String name) {
        return this.declare(position, name, 0);
    }

    public StaticScope getLocalScope() {
        return this.type != Type.BLOCK ? this : this.enclosingScope.getLocalScope();
    }

    public RubyModule getModule() {
        return this.cref;
    }

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public void setPreviousCRefScope(StaticScope crefScope) {
        this.previousCRefScope = crefScope;
    }

    public void setModule(RubyModule module) {
        this.cref = module;
        for (StaticScope scope = this.getEnclosingScope(); scope != null; scope = scope.getEnclosingScope()) {
            if (scope.cref == null) continue;
            this.previousCRefScope = scope;
            return;
        }
    }

    public RubyModule determineModule() {
        if (this.cref == null) {
            this.cref = this.getEnclosingScope().determineModule();
            assert (this.cref != null) : "CRef is always created before determine happens";
            this.previousCRefScope = this.getEnclosingScope().previousCRefScope;
        }
        return this.cref;
    }

    public boolean isBlockScope() {
        return this.isBlockOrEval;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void makeArgumentScope() {
        this.isArgumentScope = true;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public DynamicScope getDummyScope() {
        return this.dummyScope == null ? (this.dummyScope = new DummyDynamicScope(this)) : this.dummyScope;
    }

    public void setCommandArgumentStack(long commandArgumentStack) {
        this.commandArgumentStack = commandArgumentStack;
    }

    public long getCommandArgumentStack() {
        return this.commandArgumentStack;
    }

    private void growVariableNames(String name) {
        assert (name == name.intern());
        String[] newVariableNames = new String[this.variableNames.length + 1];
        System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
        this.variableNames = newVariableNames;
        this.variableNames[this.variableNames.length - 1] = name;
    }

    private void growNamedCaptures(int index) {
        boolean[] newNamedCaptures;
        boolean[] namedCaptures = this.namedCaptures;
        if (namedCaptures != null) {
            newNamedCaptures = new boolean[Math.max(index + 1, namedCaptures.length)];
            System.arraycopy(namedCaptures, 0, newNamedCaptures, 0, namedCaptures.length);
        } else {
            newNamedCaptures = new boolean[index + 1];
        }
        newNamedCaptures[index] = true;
        this.namedCaptures = newNamedCaptures;
    }

    public boolean isNamedCapture(int index) {
        boolean[] namedCaptures = this.namedCaptures;
        return namedCaptures != null && index < namedCaptures.length && namedCaptures[index];
    }

    public String toString() {
        return "StaticScope(" + (Object)((Object)this.type) + "):" + Arrays.toString(this.variableNames);
    }

    public Type getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public StaticScope duplicate() {
        StaticScope dupe = new StaticScope(this.type, this.enclosingScope, this.variableNames == null ? NO_NAMES : this.variableNames);
        if (this.irScope != null) {
            dupe.setIRScope(this.irScope);
        }
        dupe.setScopeType(this.scopeType);
        dupe.setPreviousCRefScope(this.previousCRefScope);
        dupe.setModule(this.cref);
        dupe.setSignature(this.signature);
        return dupe;
    }

    public RubyModule getOverlayModuleForRead() {
        return this.overlayModule;
    }

    public RubyModule getOverlayModuleForWrite(ThreadContext context) {
        RubyModule omod = this.overlayModule;
        if (omod == null) {
            this.overlayModule = omod = RubyModule.newModule((Ruby)context.runtime);
        }
        return omod;
    }

    public static enum Type {
        LOCAL,
        BLOCK,
        EVAL;


        public static Type fromOrdinal(int value) {
            return value < 0 || value >= Type.values().length ? null : Type.values()[value];
        }
    }
}

