/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.CatalogItemToolTip;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.FurnitureCatalogController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FurnitureCatalogListPanel
extends JPanel
implements View {
    private ListSelectionListener listSelectionListener;
    private JLabel categoryFilterLabel;
    private JComboBox categoryFilterComboBox;
    private JLabel searchLabel;
    private JTextField searchTextField;
    private JList catalogFurnitureList;

    public FurnitureCatalogListPanel(FurnitureCatalog furnitureCatalog, UserPreferences userPreferences, FurnitureCatalogController furnitureCatalogController) {
        super(new GridBagLayout());
        this.createComponents(furnitureCatalog, userPreferences, furnitureCatalogController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
    }

    private void createComponents(FurnitureCatalog furnitureCatalog, final UserPreferences userPreferences, FurnitureCatalogController furnitureCatalogController) {
        final FurnitureCatalogListModel furnitureCatalogListModel = new FurnitureCatalogListModel(furnitureCatalog);
        this.catalogFurnitureList = new JList(furnitureCatalogListModel){
            private CatalogItemToolTip toolTip;
            private boolean mousePressed;
            private boolean firstScroll;
            {
                super(listModel);
                this.toolTip = new CatalogItemToolTip(false, userPreferences);
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        firstScroll = true;
                        mousePressed = true;
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        mousePressed = false;
                    }
                });
            }

            public JToolTip createToolTip() {
                if (this.toolTip.isTipTextComplete()) {
                    return super.createToolTip();
                }
                this.toolTip.setComponent(this);
                return this.toolTip;
            }

            public String getToolTipText(MouseEvent mouseEvent) {
                int n = this.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    this.toolTip.setCatalogItem((CatalogPieceOfFurniture)this.getModel().getElementAt(n));
                    return this.toolTip.getTipText();
                }
                return null;
            }

            public void scrollRectToVisible(Rectangle rectangle) {
                if (!this.mousePressed || this.firstScroll) {
                    this.firstScroll = false;
                    super.scrollRectToVisible(rectangle);
                }
            }
        };
        this.catalogFurnitureList.setLayoutOrientation(2);
        this.catalogFurnitureList.setCellRenderer(new CatalogCellRenderer());
        this.catalogFurnitureList.setAutoscrolls(false);
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            this.catalogFurnitureList.setDragEnabled(true);
        }
        this.catalogFurnitureList.setTransferHandler(null);
        this.catalogFurnitureList.getActionMap().getParent().remove("selectAll");
        this.addDragListener(this.catalogFurnitureList);
        this.addMouseListeners(this.catalogFurnitureList, furnitureCatalogController);
        furnitureCatalogListModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }
        });
        this.catalogFurnitureList.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                FurnitureCatalogListPanel.this.spreadFurnitureIconsAlongListWidth();
            }
        });
        this.updateListSelectedFurniture(furnitureCatalog, furnitureCatalogController);
        this.addSelectionListeners(furnitureCatalog, furnitureCatalogController);
        this.categoryFilterLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurnitureCatalogListPanel.class, "categoryFilterLabel.text", new Object[0]));
        ArrayList<FurnitureCategory> arrayList = new ArrayList<FurnitureCategory>();
        arrayList.add(null);
        arrayList.addAll(furnitureCatalog.getCategories());
        this.categoryFilterComboBox = new JComboBox(new DefaultComboBoxModel<Object>(arrayList.toArray())){

            public Dimension getMinimumSize() {
                return new Dimension(60, super.getMinimumSize().height);
            }
        };
        this.categoryFilterComboBox.setMaximumRowCount(20);
        this.categoryFilterComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object == null) {
                    return super.getListCellRendererComponent((JList<?>)jList, userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterComboBox.noCategory", new Object[0]), n, bl, bl2);
                }
                return super.getListCellRendererComponent((JList<?>)jList, ((FurnitureCategory)object).getName(), n, bl, bl2);
            }
        });
        this.categoryFilterComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                furnitureCatalogListModel.setFilterCategory((FurnitureCategory)FurnitureCatalogListPanel.this.categoryFilterComboBox.getSelectedItem());
                FurnitureCatalogListPanel.this.catalogFurnitureList.clearSelection();
            }
        });
        this.searchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, FurnitureCatalogListPanel.class, "searchLabel.text", new Object[0]));
        this.searchTextField = new JTextField(5);
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                Object e = FurnitureCatalogListPanel.this.catalogFurnitureList.getSelectedValue();
                furnitureCatalogListModel.setFilterText(FurnitureCatalogListPanel.this.searchTextField.getText());
                FurnitureCatalogListPanel.this.catalogFurnitureList.clearSelection();
                FurnitureCatalogListPanel.this.catalogFurnitureList.setSelectedValue(e, true);
                if (furnitureCatalogListModel.getSize() == 1) {
                    FurnitureCatalogListPanel.this.catalogFurnitureList.setSelectedIndex(0);
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.searchTextField.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "deleteContent");
        this.searchTextField.getActionMap().put("deleteContent", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FurnitureCatalogListPanel.this.searchTextField.setText("");
            }
        });
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.searchTextField.putClientProperty("JTextField.variant", "search");
        }
        PreferencesChangeListener preferencesChangeListener = new PreferencesChangeListener(this);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, preferencesChangeListener);
        furnitureCatalog.addFurnitureListener(preferencesChangeListener);
    }

    private void addDragListener(final JList jList) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private CatalogPieceOfFurniture exportedPiece;

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                this.exportedPiece = null;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && jList.getSelectedValue() != null && jList.getTransferHandler() != null && (n = jList.locationToIndex(mouseEvent.getPoint())) != -1) {
                    this.exportedPiece = (CatalogPieceOfFurniture)jList.getModel().getElementAt(n);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.exportedPiece != null) {
                    if (jList.getSelectedIndices().length > 1) {
                        jList.clearSelection();
                        jList.setSelectedValue(this.exportedPiece, false);
                    }
                    if (!OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                        jList.getTransferHandler().exportAsDrag(jList, mouseEvent, 1);
                    }
                    this.exportedPiece = null;
                }
            }
        };
        jList.addMouseListener(mouseInputAdapter);
        jList.addMouseMotionListener(mouseInputAdapter);
    }

    private void addMouseListeners(final JList jList, final FurnitureCatalogController furnitureCatalogController) {
        final Cursor cursor = new Cursor(12);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    URL uRL;
                    if (mouseEvent.getClickCount() == 2) {
                        int n = jList.locationToIndex(mouseEvent.getPoint());
                        if (n != -1) {
                            furnitureCatalogController.modifySelectedFurniture();
                        }
                    } else if (jList.getCellRenderer() instanceof CatalogCellRenderer && (uRL = ((CatalogCellRenderer)jList.getCellRenderer()).getURLAt(mouseEvent.getPoint(), (JList)mouseEvent.getSource())) != null) {
                        SwingTools.showDocumentInBrowser(uRL);
                    }
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                URL uRL;
                if (jList.getCellRenderer() instanceof CatalogCellRenderer && (uRL = ((CatalogCellRenderer)jList.getCellRenderer()).getURLAt(mouseEvent.getPoint(), (JList)mouseEvent.getSource())) != null) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FurnitureCatalogListPanel.this.setCursor(cursor);
                        }
                    });
                }
                FurnitureCatalogListPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        jList.addMouseListener(mouseInputAdapter);
        jList.addMouseMotionListener(mouseInputAdapter);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.categoryFilterLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "categoryFilterLabel.mnemonic", new Object[0])).getKeyCode());
            this.categoryFilterLabel.setLabelFor(this.categoryFilterComboBox);
            this.searchLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(FurnitureCatalogListPanel.class, "searchLabel.mnemonic", new Object[0])).getKeyCode());
            this.searchLabel.setLabelFor(this.searchTextField);
        }
    }

    private void layoutComponents() {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        Insets insets = new Insets(0, 2, 5, 3);
        Insets insets2 = new Insets(0, 2, 3, 0);
        if (!OperatingSystem.isMacOSX()) {
            insets.top = 2;
            insets2.top = 2;
            insets2.right = 2;
        }
        this.add((Component)this.categoryFilterLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this.add((Component)this.categoryFilterComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.add((Component)this.searchTextField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 3, 0), 0, 0));
        } else {
            this.add((Component)this.searchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
            this.add((Component)this.searchTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        }
        JScrollPane jScrollPane = new JScrollPane(this.catalogFurnitureList);
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(SwingTools.createAdjustmentListenerUpdatingScrollPaneViewToolTip(jScrollPane));
        jScrollPane.setPreferredSize(new Dimension(250, 250));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        SwingTools.installFocusBorder(this.catalogFurnitureList);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureCatalogListPanel.this.setFocusTraversalPolicyProvider(false);
                    }
                });
                return FurnitureCatalogListPanel.this.catalogFurnitureList;
            }
        });
    }

    private void spreadFurnitureIconsAlongListWidth() {
        int n = this.catalogFurnitureList.getModel().getSize();
        int n2 = ((JViewport)this.catalogFurnitureList.getParent()).getExtentSize().width;
        ListCellRenderer listCellRenderer = this.catalogFurnitureList.getCellRenderer();
        Dimension dimension = ((JComponent)((Object)listCellRenderer)).getPreferredSize();
        int n3 = dimension.width;
        int n4 = Math.max(1, n2 / n3);
        this.catalogFurnitureList.setVisibleRowCount(n % n4 == 0 ? n / n4 : n / n4 + 1);
        this.catalogFurnitureList.setFixedCellWidth(n3 + n2 % n3 / n4);
        if (listCellRenderer instanceof CatalogCellRenderer) {
            this.catalogFurnitureList.setFixedCellHeight(((CatalogCellRenderer)listCellRenderer).getPreferredHeight(this.catalogFurnitureList));
        } else {
            this.catalogFurnitureList.setFixedCellHeight(dimension.height);
        }
    }

    private void addSelectionListeners(final FurnitureCatalog furnitureCatalog, final FurnitureCatalogController furnitureCatalogController) {
        final SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureCatalogListPanel.this.updateListSelectedFurniture(furnitureCatalog, furnitureCatalogController);
            }
        };
        this.listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                furnitureCatalogController.removeSelectionListener(selectionListener);
                furnitureCatalogController.setSelectedFurniture(FurnitureCatalogListPanel.this.getSelectedFurniture());
                furnitureCatalogController.addSelectionListener(selectionListener);
            }
        };
        furnitureCatalogController.addSelectionListener(selectionListener);
        this.catalogFurnitureList.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    private void updateListSelectedFurniture(FurnitureCatalog furnitureCatalog, FurnitureCatalogController furnitureCatalogController) {
        if (this.listSelectionListener != null) {
            this.catalogFurnitureList.getSelectionModel().removeListSelectionListener(this.listSelectionListener);
        }
        this.catalogFurnitureList.clearSelection();
        List<CatalogPieceOfFurniture> list = furnitureCatalogController.getSelectedFurniture();
        if (list.size() > 0) {
            ListModel listModel = this.catalogFurnitureList.getModel();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            block0: for (CatalogPieceOfFurniture catalogPieceOfFurniture : list) {
                int n = listModel.getSize();
                for (int i = 0; i < n; ++i) {
                    if (catalogPieceOfFurniture != listModel.getElementAt(i)) continue;
                    arrayList.add(i);
                    continue block0;
                }
            }
            if (arrayList.size() > 0) {
                Object object = new int[arrayList.size()];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = (Integer)arrayList.get(i);
                }
                this.catalogFurnitureList.setSelectedIndices((int[])object);
                this.catalogFurnitureList.ensureIndexIsVisible((int)object[0]);
            }
        }
        if (this.listSelectionListener != null) {
            this.catalogFurnitureList.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        }
    }

    private List<CatalogPieceOfFurniture> getSelectedFurniture() {
        Object[] objectArray = this.catalogFurnitureList.getSelectedValues();
        CatalogPieceOfFurniture[] catalogPieceOfFurnitureArray = new CatalogPieceOfFurniture[objectArray.length];
        System.arraycopy(objectArray, 0, catalogPieceOfFurnitureArray, 0, objectArray.length);
        return Arrays.asList(catalogPieceOfFurnitureArray);
    }

    @Override
    public void setTransferHandler(TransferHandler transferHandler) {
        this.catalogFurnitureList.setTransferHandler(transferHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return this.catalogFurnitureList.getTransferHandler();
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        this.catalogFurnitureList.setComponentPopupMenu(jPopupMenu);
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        return this.catalogFurnitureList.getComponentPopupMenu();
    }

    private static class FurnitureCatalogListModel
    extends AbstractListModel {
        private FurnitureCatalog catalog;
        private List<CatalogPieceOfFurniture> furniture;
        private FurnitureCategory filterCategory;
        private String filterText;

        public FurnitureCatalogListModel(FurnitureCatalog furnitureCatalog) {
            this.catalog = furnitureCatalog;
            this.filterText = "";
            furnitureCatalog.addFurnitureListener(new FurnitureCatalogListener(this));
        }

        public void setFilterCategory(FurnitureCategory furnitureCategory) {
            this.filterCategory = furnitureCategory;
            this.resetFurnitureList();
        }

        public void setFilterText(String string) {
            this.filterText = string;
            this.resetFurnitureList();
        }

        public Object getElementAt(int n) {
            this.checkFurnitureList();
            return this.furniture.get(n);
        }

        public int getSize() {
            this.checkFurnitureList();
            return this.furniture.size();
        }

        private void resetFurnitureList() {
            if (this.furniture != null) {
                this.furniture = null;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureCatalogListModel.this.fireContentsChanged(this, -1, -1);
                    }
                });
            }
        }

        private void checkFurnitureList() {
            if (this.furniture == null) {
                this.furniture = new ArrayList<CatalogPieceOfFurniture>();
                this.furniture.clear();
                for (FurnitureCategory furnitureCategory : this.catalog.getCategories()) {
                    for (CatalogPieceOfFurniture catalogPieceOfFurniture : furnitureCategory.getFurniture()) {
                        if (this.filterCategory != null && !catalogPieceOfFurniture.getCategory().equals(this.filterCategory) || !catalogPieceOfFurniture.matchesFilter(this.filterText)) continue;
                        this.furniture.add(catalogPieceOfFurniture);
                    }
                }
                Collections.sort(this.furniture);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class FurnitureCatalogListener
        implements CollectionListener<CatalogPieceOfFurniture> {
            private WeakReference<FurnitureCatalogListModel> listModel;

            public FurnitureCatalogListener(FurnitureCatalogListModel furnitureCatalogListModel) {
                this.listModel = new WeakReference<FurnitureCatalogListModel>(furnitureCatalogListModel);
            }

            @Override
            public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
                FurnitureCatalogListModel furnitureCatalogListModel = (FurnitureCatalogListModel)this.listModel.get();
                FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
                if (furnitureCatalogListModel == null) {
                    furnitureCatalog.removeFurnitureListener(this);
                } else {
                    furnitureCatalogListModel.resetFurnitureList();
                }
            }
        }
    }

    private static class CatalogCellRenderer
    extends JComponent
    implements ListCellRenderer {
        private static final int DEFAULT_ICON_HEIGHT = Math.round(48.0f * SwingTools.getResolutionScale());
        private Font defaultFont;
        private Font modifiablePieceFont;
        private DefaultListCellRenderer nameLabel;
        private JEditorPane informationPane;

        public CatalogCellRenderer() {
            this.setLayout(null);
            this.nameLabel = new DefaultListCellRenderer(){

                public Dimension getPreferredSize() {
                    return new Dimension(DEFAULT_ICON_HEIGHT * 3 / 2 + 5, super.getPreferredSize().height);
                }
            };
            this.nameLabel.setHorizontalTextPosition(0);
            this.nameLabel.setVerticalTextPosition(3);
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setText("-");
            this.nameLabel.setIcon(IconManager.getInstance().getWaitIcon(DEFAULT_ICON_HEIGHT));
            this.defaultFont = UIManager.getFont("ToolTip.font");
            this.modifiablePieceFont = new Font(this.defaultFont.getFontName(), 2, this.defaultFont.getSize());
            this.nameLabel.setFont(this.defaultFont);
            this.informationPane = new JEditorPane("text/html", "-");
            this.informationPane.setOpaque(false);
            this.informationPane.setEditable(false);
            String string = "body { font-family: " + this.defaultFont.getFamily() + "; " + "font-size: " + this.defaultFont.getSize() + "pt; " + "text-align: center; }";
            ((HTMLDocument)this.informationPane.getDocument()).getStyleSheet().addRule(string);
            this.add(this.nameLabel);
            this.add(this.informationPane);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CatalogPieceOfFurniture catalogPieceOfFurniture = (CatalogPieceOfFurniture)object;
            this.nameLabel.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.nameLabel.setText(" " + catalogPieceOfFurniture.getName() + " ");
            this.nameLabel.setIcon(this.getLabelIcon(jList, catalogPieceOfFurniture.getIcon()));
            this.nameLabel.setFont(catalogPieceOfFurniture.isModifiable() ? this.modifiablePieceFont : this.defaultFont);
            String string = catalogPieceOfFurniture.getInformation();
            if (string != null) {
                this.informationPane.setText(string);
                this.informationPane.setVisible(true);
            } else {
                this.informationPane.setVisible(false);
            }
            return this;
        }

        public int getPreferredHeight(JList jList) {
            ListModel listModel = jList.getModel();
            this.informationPane.setVisible(false);
            int n = listModel.getSize();
            for (int i = 0; i < n; ++i) {
                if (((CatalogPieceOfFurniture)listModel.getElementAt(i)).getInformation() == null) continue;
                this.informationPane.setVisible(true);
                break;
            }
            return this.getPreferredSize().height;
        }

        public void doLayout() {
            Dimension dimension = this.nameLabel.getPreferredSize();
            this.nameLabel.setSize(this.getWidth(), dimension.height);
            if (this.informationPane.isVisible()) {
                this.informationPane.setBounds(0, dimension.height, this.getWidth(), this.getHeight() - dimension.height);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.nameLabel.getPreferredSize();
            if (this.informationPane.isVisible()) {
                dimension.height += this.informationPane.getPreferredSize().height + 2;
            }
            return dimension;
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        public void repaint() {
        }

        private Icon getLabelIcon(JList jList, Content content) {
            return IconManager.getInstance().getIcon(content, DEFAULT_ICON_HEIGHT, jList);
        }

        protected void paintChildren(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintChildren(graphics);
        }

        public URL getURLAt(Point point, JList jList) {
            CatalogPieceOfFurniture catalogPieceOfFurniture;
            String string;
            int n = jList.locationToIndex(point);
            if (n != -1 && (string = (catalogPieceOfFurniture = (CatalogPieceOfFurniture)jList.getModel().getElementAt(n)).getInformation()) != null) {
                String string2;
                HTMLDocument hTMLDocument;
                Element element;
                AttributeSet attributeSet;
                AttributeSet attributeSet2;
                int n2;
                this.getListCellRendererComponent(jList, catalogPieceOfFurniture, n, false, false);
                Rectangle rectangle = jList.getCellBounds(n, n);
                point.x -= rectangle.x;
                point.y -= rectangle.y + this.informationPane.getY();
                if (point.x > 0 && point.y > 0 && (n2 = this.informationPane.viewToModel(point)) > 1 && (attributeSet2 = (AttributeSet)(attributeSet = (element = (hTMLDocument = (HTMLDocument)this.informationPane.getDocument()).getCharacterElement(n2)).getAttributes()).getAttribute(HTML.Tag.A)) != null && (string2 = (String)attributeSet2.getAttribute(HTML.Attribute.HREF)) != null) {
                    try {
                        return new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreferencesChangeListener
    implements PropertyChangeListener,
    CollectionListener<CatalogPieceOfFurniture> {
        private final WeakReference<FurnitureCatalogListPanel> furnitureCatalogPanel;

        public PreferencesChangeListener(FurnitureCatalogListPanel furnitureCatalogListPanel) {
            this.furnitureCatalogPanel = new WeakReference<FurnitureCatalogListPanel>(furnitureCatalogListPanel);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureCatalogListPanel furnitureCatalogListPanel = (FurnitureCatalogListPanel)this.furnitureCatalogPanel.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (furnitureCatalogListPanel == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                furnitureCatalogListPanel.categoryFilterLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, FurnitureCatalogListPanel.class, "categoryFilterLabel.text", new Object[0]));
                furnitureCatalogListPanel.searchLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, FurnitureCatalogListPanel.class, "searchLabel.text", new Object[0]));
                furnitureCatalogListPanel.setMnemonics(userPreferences);
            }
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            FurnitureCatalogListPanel furnitureCatalogListPanel = (FurnitureCatalogListPanel)this.furnitureCatalogPanel.get();
            FurnitureCatalog furnitureCatalog = (FurnitureCatalog)collectionEvent.getSource();
            if (furnitureCatalogListPanel == null) {
                furnitureCatalog.removeFurnitureListener(this);
            } else {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)furnitureCatalogListPanel.categoryFilterComboBox.getModel();
                FurnitureCategory furnitureCategory = collectionEvent.getItem().getCategory();
                List<FurnitureCategory> list = furnitureCatalog.getCategories();
                if (!list.contains(furnitureCategory)) {
                    defaultComboBoxModel.removeElement(furnitureCategory);
                    furnitureCatalogListPanel.categoryFilterComboBox.setSelectedIndex(0);
                } else if (defaultComboBoxModel.getIndexOf(furnitureCategory) == -1) {
                    defaultComboBoxModel.insertElementAt(furnitureCategory, list.indexOf(furnitureCategory) + 1);
                }
            }
        }
    }
}

