/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.border.Border;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.swing.graphics.Scale;

public class ScaleBorder
implements Border {
    private static final String DELTA = "\u0394";
    private static final String PRIME = "\u00b4";
    private static final String DOT = "\u00b7";
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    public static final int TYPE_PARALLEL_TRANSFORM = 0;
    public static final int TYPE_SWITCHED_TRANSFORM = 1;
    public static final int TYPE_X_SKEW_TRANSFORM = 2;
    public static final int TYPE_Y_SKEW_TRANSFORM = 3;
    public static final int TYPE_SWITCHED_X_SKEW_TRANSFORM = 4;
    public static final int TYPE_SWITCHED_Y_SKEW_TRANSFORM = 5;
    public static final int TYPE_GENERAL_TRANSFORM = 6;
    private Color bkgColor;
    private Color fgColor;
    private GeneralPath[] pTicks = new GeneralPath[2];
    private GeneralPath[] sTicks = new GeneralPath[2];
    private String[] axisLabels = new String[2];
    private String[] axisUnits = new String[2];
    private String[][] labels;
    private double[][] positions;
    private int fontSize = 12;
    private Font labelFont = new Font("SansSerif", 1, this.fontSize);
    private static final Stroke thinStroke = new BasicStroke(1.0f);
    private static final Stroke thickStroke = new BasicStroke(2.0f);
    private double[] axisPts = new double[6];
    private boolean scaleChanged;
    private int currentWidth;
    private int currentHeight;
    private double minHoriz = 0.0;
    private double maxHoriz = 0.0;
    private double minVert = 0.0;
    private double maxVert = 0.0;
    private Insets insets;

    public ScaleBorder() {
        this(Color.orange, Color.black);
    }

    public ScaleBorder(Color bkgColor, Color fgColor) {
        this.resetInsets();
        this.pTicks[0] = new GeneralPath();
        this.pTicks[1] = new GeneralPath();
        this.sTicks[0] = new GeneralPath();
        this.sTicks[1] = new GeneralPath();
        this.labels = new String[2][3];
        this.positions = new double[2][3];
        this.currentWidth = 0;
        this.currentHeight = 0;
        this.scaleChanged = false;
        this.setBackgroundColor(bkgColor);
        this.setForegroundColor(fgColor);
    }

    public void setBackgroundColor(Color bkgColor) {
        this.bkgColor = bkgColor;
    }

    public Color getBackgroundColor() {
        return this.bkgColor;
    }

    public void setForegroundColor(Color bkgColor) {
        this.fgColor = bkgColor;
    }

    public Color getForegroundColor() {
        return this.fgColor;
    }

    public void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
        this.fontSize = labelFont.getSize();
        this.resetInsets();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLimits(double minHoriz, double maxHoriz, double minVert, double maxVert) {
        this.minHoriz = minHoriz;
        this.maxHoriz = maxHoriz;
        this.minVert = minVert;
        this.maxVert = maxVert;
        this.scaleChanged = true;
    }

    public void setAxisLabels(String horizontalLabel, String verticalLabel) {
        this.axisLabels[0] = horizontalLabel;
        this.axisLabels[1] = verticalLabel;
    }

    public void setAxisUnits(String horizontalUnits, String verticalUnits) {
        this.axisUnits[0] = horizontalUnits != null ? "(" + horizontalUnits + ")" : "";
        this.axisUnits[1] = verticalUnits != null ? "(" + verticalUnits + ")" : "";
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)this.insets.clone();
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.scaleChanged = this.scaleChanged || width != this.currentWidth || height != this.currentHeight;
        VectorGraphics vg = VectorGraphics.create(g);
        if (vg != null) {
            vg.setColor(this.bkgColor);
            vg.fillRect(0, 0, width, this.insets.top);
            vg.fillRect(0, 0, this.insets.left, height);
            vg.fillRect(width - this.insets.right, 0, this.insets.right, height);
            vg.fillRect(0, height - this.insets.bottom, width, this.insets.bottom);
            if (this.scaleChanged) {
                Scale.drawLinearScale(this.minHoriz, this.maxHoriz, width - (this.insets.left + this.insets.right), 3, 7, 1, this.pTicks[0], this.sTicks[0], this.labels[0], this.positions[0]);
            }
            Graphics sg = vg.create();
            VectorGraphics svg = VectorGraphics.create(sg);
            svg.translate(this.insets.left, height - this.insets.bottom + 2);
            svg.setColor(this.fgColor);
            svg.setFont(this.labelFont);
            svg.setStroke(thickStroke);
            svg.draw(this.pTicks[0]);
            svg.setStroke(thinStroke);
            svg.draw(this.sTicks[0]);
            for (int i = 0; i < 3; ++i) {
                if (this.labels[0][i] == null) continue;
                svg.drawString(this.labels[0][i], (double)((float)this.positions[0][i]), (double)(Scale.getPrimaryTickSize() + 0.2f * (float)this.fontSize), 2, 1);
            }
            float axisPosition = Math.abs(this.positions[0][2] - this.positions[0][1]) > Math.abs(this.positions[0][2] - this.positions[0][0]) ? (float)(0.5 * (this.positions[0][2] + this.positions[0][1])) : (float)(0.5 * (this.positions[0][2] + this.positions[0][0]));
            svg.drawString(this.axisLabels[0] + " " + this.axisUnits[0], (double)axisPosition, (double)(Scale.getPrimaryTickSize() + 0.2f * (float)this.fontSize), 2, 1);
            svg.dispose();
            if (this.scaleChanged) {
                Scale.drawLinearScale(this.minVert, this.maxVert, height - (this.insets.top + this.insets.bottom), 3, 7, 0, this.pTicks[1], this.sTicks[1], this.labels[1], this.positions[1]);
            }
            sg = vg.create();
            svg = VectorGraphics.create(sg);
            svg.translate(this.insets.left - 2, height - this.insets.bottom);
            svg.rotate(-1.5707963267948966);
            svg.setColor(this.fgColor);
            svg.setFont(this.labelFont);
            svg.setStroke(thickStroke);
            svg.draw(this.pTicks[1]);
            svg.setStroke(thinStroke);
            svg.draw(this.sTicks[1]);
            for (int i = 0; i < 3; ++i) {
                if (this.labels[1][i] == null) continue;
                svg.drawString(this.labels[1][i], (double)((float)this.positions[1][i]), (double)(-(Scale.getPrimaryTickSize() + 0.2f * (float)this.fontSize)), 2, 3);
            }
            axisPosition = Math.abs(this.positions[1][2] - this.positions[1][1]) > Math.abs(this.positions[1][2] - this.positions[1][0]) ? (float)(0.5 * (this.positions[1][2] + this.positions[1][1])) : (float)(0.5 * (this.positions[1][2] + this.positions[1][0]));
            svg.drawString(this.axisLabels[1] + " " + this.axisUnits[1], (double)axisPosition, (double)(-(Scale.getPrimaryTickSize() + 0.2f * (float)this.fontSize)), 2, 3);
            svg.dispose();
            this.currentWidth = width;
            this.currentHeight = height;
            this.scaleChanged = false;
        }
    }

    private void resetInsets() {
        int lb = (int)((double)(4.0f + Scale.getPrimaryTickSize()) + 1.5 * (double)this.fontSize);
        int tr = (int)(4.0f + Scale.getPrimaryTickSize());
        this.insets = new Insets(tr, lb, lb, tr);
    }

    public void setScales(String horizLabel, String vertLabel, String horizUnits, String vertUnits, AffineTransform transform, int panelWidth, int panelHeight) {
        int type = ScaleBorder.classifyTransform(transform);
        switch (type) {
            case 0: {
                this.setAxisLabels(horizLabel, vertLabel);
                this.setAxisUnits(horizUnits, vertUnits);
                break;
            }
            case 1: {
                this.setAxisLabels(vertLabel, horizLabel);
                this.setAxisUnits(vertUnits, horizUnits);
                break;
            }
            case 3: {
                this.setAxisLabels(horizLabel + PRIME, DELTA + vertLabel);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits + DOT + vertUnits, vertUnits);
                break;
            }
            case 2: {
                this.setAxisLabels(DELTA + horizLabel, vertLabel + PRIME);
                if (vertUnits.equals(horizUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits, vertUnits + DOT + horizUnits);
                break;
            }
            case 5: {
                this.setAxisLabels(vertLabel + PRIME, DELTA + horizLabel);
                if (vertUnits.equals(horizUnits)) {
                    this.setAxisUnits(vertUnits, horizUnits);
                    break;
                }
                this.setAxisUnits(vertUnits + DOT + horizUnits, horizUnits);
                break;
            }
            case 4: {
                this.setAxisLabels(DELTA + vertLabel, horizLabel + PRIME);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(vertUnits, horizUnits);
                    break;
                }
                this.setAxisUnits(vertUnits, horizUnits + DOT + vertUnits);
                break;
            }
            default: {
                this.setAxisLabels(horizLabel + PRIME, vertLabel + PRIME);
                if (horizUnits.equals(vertUnits)) {
                    this.setAxisUnits(horizUnits, vertUnits);
                    break;
                }
                this.setAxisUnits(horizUnits + DOT + vertUnits, vertUnits + DOT + horizUnits);
            }
        }
        this.axisPts[0] = 0.0;
        this.axisPts[1] = panelHeight;
        this.axisPts[2] = 0.0;
        this.axisPts[3] = panelHeight;
        this.axisPts[4] = panelWidth;
        this.axisPts[5] = 0.0;
        try {
            AffineTransform ixform = transform.createInverse();
            ixform.transform(this.axisPts, 0, this.axisPts, 0, 1);
            ixform.deltaTransform(this.axisPts, 2, this.axisPts, 2, 2);
            double vdy = this.axisPts[3];
            double vdx = this.axisPts[2];
            double vdist = Math.sqrt(vdx * vdx + vdy * vdy);
            double hdy = this.axisPts[5];
            double hdx = this.axisPts[4];
            double hdist = Math.sqrt(hdx * hdx + hdy * hdy);
            double vmin = 0.0;
            double vmax = 0.0;
            double hmin = 0.0;
            double hmax = 0.0;
            switch (type) {
                case 0: {
                    double vsign = vdy < 0.0 ? 1.0 : -1.0;
                    vmin = this.axisPts[1];
                    vmax = this.axisPts[1] + vsign * vdist;
                    double hsign = hdx > 0.0 ? 1.0 : -1.0;
                    hmin = this.axisPts[0];
                    hmax = this.axisPts[0] + hsign * hdist;
                    break;
                }
                case 1: {
                    double hsign = hdy > 0.0 ? 1.0 : -1.0;
                    hmin = this.axisPts[1];
                    hmax = this.axisPts[1] + hsign * hdist;
                    double vsign = vdx < 0.0 ? 1.0 : -1.0;
                    vmin = this.axisPts[0];
                    vmax = this.axisPts[0] + vsign * vdist;
                    break;
                }
                case 3: {
                    double vsign = vdy > 0.0 ? 1.0 : -1.0;
                    vmax = -vsign * vdist / 2.0;
                    vmin = -vmax;
                    hmin = 0.0;
                    hmax = hdist;
                    break;
                }
                case 2: {
                    double hsign = hdx > 0.0 ? 1.0 : -1.0;
                    hmax = hsign * hdist / 2.0;
                    hmin = -hmax;
                    vmin = 0.0;
                    vmax = vdist;
                    break;
                }
                case 5: {
                    double vsign = vdx > 0.0 ? 1.0 : -1.0;
                    vmax = -vsign * vdist / 2.0;
                    vmin = -vmax;
                    hmin = 0.0;
                    hmax = hdist;
                    break;
                }
                case 4: {
                    double hsign = hdy > 0.0 ? 1.0 : -1.0;
                    hmax = hsign * hdist / 2.0;
                    hmin = -hmax;
                    vmin = 0.0;
                    vmax = vdist;
                    break;
                }
                default: {
                    vmin = 0.0;
                    vmax = vdist;
                    hmin = 0.0;
                    hmax = hdist;
                }
            }
            this.setLimits(hmin, hmax, vmin, vmax);
        }
        catch (Exception e) {
            this.setLimits(0.0, 0.0, 0.0, 0.0);
        }
    }

    protected static int classifyTransform(AffineTransform xform) {
        int category = 6;
        double sx = xform.getScaleX();
        double sy = xform.getScaleY();
        double kx = xform.getShearX();
        double ky = xform.getShearY();
        if (kx == 0.0 && ky == 0.0) {
            category = 0;
        } else if (sx == 0.0 && sy == 0.0) {
            category = 1;
        } else if (kx == 0.0) {
            category = 3;
        } else if (ky == 0.0) {
            category = 2;
        } else if (sx == 0.0) {
            category = 5;
        } else if (sy == 0.0) {
            category = 4;
        }
        return category;
    }
}

