/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.EventQueue;
import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.extension.history.PopupMenuExportMessage;
import org.parosproxy.paros.extension.history.PopupMenuExportResponse;
import org.parosproxy.paros.extension.history.ProxyListenerLog;
import org.parosproxy.paros.extension.manualrequest.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.manualrequest.http.impl.ManualHttpRequestEditorDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.history.AlertAddDialog;
import org.zaproxy.zap.extension.history.HistoryFilterPlusDialog;
import org.zaproxy.zap.extension.history.ManageTagsDialog;
import org.zaproxy.zap.extension.history.NotesAddDialog;
import org.zaproxy.zap.extension.history.PopupMenuExportURLs;
import org.zaproxy.zap.extension.history.PopupMenuNote;
import org.zaproxy.zap.extension.history.PopupMenuPurgeHistory;
import org.zaproxy.zap.extension.history.PopupMenuTag;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableModel;

public class ExtensionHistory
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionHistory";
    private static final DefaultHistoryReferencesTableModel EMPTY_MODEL = new DefaultHistoryReferencesTableModel();
    private LogPanel logPanel = null;
    private ProxyListenerLog proxyListener = null;
    private DefaultHistoryReferencesTableModel historyTableModel;
    private HistoryFilterPlusDialog filterPlusDialog = null;
    private PopupMenuPurgeHistory popupMenuPurgeHistory = null;
    private ManualRequestEditorDialog resendDialog = null;
    private PopupMenuExportMessage popupMenuExportMessage2 = null;
    private PopupMenuExportResponse popupMenuExportResponse2 = null;
    private PopupMenuTag popupMenuTag = null;
    private PopupMenuExportURLs popupMenuExportURLs = null;
    private PopupMenuNote popupMenuNote = null;
    private NotesAddDialog dialogNotesAdd = null;
    private AlertAddDialog dialogAlertAdd = null;
    private ManageTagsDialog manageTags = null;
    private boolean showJustInScope = false;
    private boolean linkWithSitesTree;
    private String linkWithSitesTreeBaseUri;
    private ReferenceMap historyIdToRef = new ReferenceMap();
    private Logger logger = Logger.getLogger(ExtensionHistory.class);

    public ExtensionHistory() {
        this.initialize();
    }

    public ExtensionHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(16);
    }

    private LogPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new LogPanel(this.getView());
            this.logPanel.setName(Constant.messages.getString("history.panel.title"));
            this.logPanel.setIcon(new ImageIcon(ExtensionHistory.class.getResource("/resource/icon/16/025.png")));
            this.logPanel.setHideable(false);
            this.logPanel.setExtension(this);
            this.logPanel.setModel(this.historyTableModel);
        }
        return this.logPanel;
    }

    public void clearLogPanelDisplayQueue() {
        this.getLogPanel().clearDisplayQueue();
    }

    public HistoryReference getSelectedHistoryReference() {
        return this.getLogPanel().getSelectedHistoryReference();
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        return this.getLogPanel().getSelectedHistoryReferences();
    }

    @Override
    public void init() {
        super.init();
        this.historyTableModel = new DefaultHistoryReferencesTableModel();
        ZAP.getEventBus().registerConsumer(new AlertEventConsumer(), AlertEventPublisher.getPublisher().getPublisherName());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        extensionHook.addProxyListener(this.getProxyListenerLog());
        extensionHook.addConnectionRequestProxyListener(this.getProxyListenerLog());
        if (this.getView() != null) {
            ExtensionHookView extensionHookView = extensionHook.getHookView();
            extensionHookView.addStatusPanel(this.getLogPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuTag());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuNote());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuPurgeHistory());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportMessage2());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportResponse2());
            extensionHook.getHookMenu().addReportMenuItem(this.getPopupMenuExportURLs());
            ExtensionHelp.enableHelpKey(this.getLogPanel(), "ui.tabs.history");
        }
    }

    @Override
    public void sessionChanged(Session session) {
    }

    private ProxyListenerLog getProxyListenerLog() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerLog(this.getModel(), this.getView(), this);
        }
        return this.proxyListener;
    }

    public void removeFromHistoryList(final HistoryReference historyReference) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.removeEntry(historyReference.getHistoryId());
            this.historyIdToRef.remove((Object)historyReference.getHistoryId());
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.removeFromHistoryList(historyReference);
                }
            });
        }
    }

    public void notifyHistoryItemChanged(HistoryReference historyReference) {
        this.notifyHistoryItemChanged(historyReference.getHistoryId());
    }

    private void notifyHistoryItemChanged(final int n) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.refreshEntryRow(n);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.notifyHistoryItemChanged(n);
                }
            });
        }
    }

    private void notifyHistoryItemsChanged() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.refreshEntryRows();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionHistory.this.notifyHistoryItemsChanged();
                }
            });
        }
    }

    public void delete(HistoryReference historyReference) {
        if (historyReference != null) {
            this.historyIdToRef.remove((Object)historyReference.getHistoryId());
            historyReference.delete();
        }
    }

    public HistoryReference getHistoryReference(int n) {
        HistoryReference historyReference = this.historyTableModel.getHistoryReference(n);
        if (historyReference != null) {
            return historyReference;
        }
        historyReference = (HistoryReference)this.historyIdToRef.get((Object)n);
        if (historyReference == null) {
            try {
                historyReference = new HistoryReference(n);
                if (historyReference.getHistoryType() != 14) {
                    this.addToMap(historyReference);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return historyReference;
    }

    public int getLastHistoryId() {
        return Model.getSingleton().getDb().getTableHistory().lastIndex();
    }

    public void addHistory(HttpMessage httpMessage, int n) {
        try {
            this.addHistory(new HistoryReference(Model.getSingleton().getSession(), n, httpMessage));
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void addToMap(HistoryReference historyReference) {
        this.historyIdToRef.put((Object)historyReference.getHistoryId(), (Object)historyReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistory(HistoryReference historyReference) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        try {
            DefaultHistoryReferencesTableModel defaultHistoryReferencesTableModel = this.historyTableModel;
            synchronized (defaultHistoryReferencesTableModel) {
                if (ExtensionHistory.isHistoryTypeToShow(historyReference.getHistoryType())) {
                    String string = historyReference.getURI().toString();
                    if (this.showJustInScope && !this.getModel().getSession().isInScope(string)) {
                        this.addToMap(historyReference);
                        return;
                    }
                    if (this.linkWithSitesTree && this.linkWithSitesTreeBaseUri != null && !string.startsWith(this.linkWithSitesTreeBaseUri)) {
                        this.addToMap(historyReference);
                        return;
                    }
                    if (this.getView() != null) {
                        HistoryFilterPlusDialog historyFilterPlusDialog = this.getFilterPlusDialog();
                        HistoryFilter historyFilter = historyFilterPlusDialog.getFilter();
                        if (historyFilter != null && !historyFilter.matches(historyReference)) {
                            this.addToMap(historyReference);
                            return;
                        }
                        this.addHistoryInEventQueue(historyReference);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private static boolean isHistoryTypeToShow(int n) {
        return n == 1 || n == 15 || n == 11 || n == 16;
    }

    private void addHistoryInEventQueue(final HistoryReference historyReference) {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.historyTableModel.addHistoryReference(historyReference);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionHistory.this.addHistoryInEventQueue(historyReference);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchHistory(HistoryFilter historyFilter) {
        Session session = this.getModel().getSession();
        DefaultHistoryReferencesTableModel defaultHistoryReferencesTableModel = this.historyTableModel;
        synchronized (defaultHistoryReferencesTableModel) {
            try {
                List<Integer> list = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15, 16);
                this.buildHistory(list, historyFilter);
            }
            catch (DatabaseException databaseException) {
                this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHistory(List<Integer> list, HistoryFilter historyFilter) {
        HistoryReference historyReference = null;
        DefaultHistoryReferencesTableModel defaultHistoryReferencesTableModel = this.historyTableModel;
        synchronized (defaultHistoryReferencesTableModel) {
            if (this.getView() != null) {
                this.getLogPanel().setModel(EMPTY_MODEL);
            }
            this.historyTableModel.clear();
            for (int i = 0; i < list.size(); ++i) {
                int n = list.get(i);
                try {
                    SiteNode siteNode = this.getModel().getSession().getSiteTree().getSiteNode(n);
                    if (siteNode != null && siteNode.getHistoryReference() != null && siteNode.getHistoryReference().getHistoryId() == n) {
                        historyReference = siteNode.getHistoryReference();
                    } else {
                        historyReference = this.getHistoryReference(n);
                        if (siteNode != null) {
                            siteNode.setHistoryReference(historyReference);
                        }
                    }
                    String string = historyReference.getURI().toString();
                    if (this.showJustInScope && !this.getModel().getSession().isInScope(string) || this.linkWithSitesTree && this.linkWithSitesTreeBaseUri != null && !string.startsWith(this.linkWithSitesTreeBaseUri) || historyFilter != null && !historyFilter.matches(historyReference)) continue;
                    historyReference.loadAlerts();
                    this.historyTableModel.addHistoryReference(historyReference);
                    continue;
                }
                catch (Exception exception) {
                    this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (this.getView() != null) {
                this.getLogPanel().setModel(this.historyTableModel);
            }
        }
    }

    private HistoryFilterPlusDialog getFilterPlusDialog() {
        if (this.filterPlusDialog == null) {
            this.filterPlusDialog = new HistoryFilterPlusDialog((Frame)this.getView().getMainFrame(), true);
        }
        return this.filterPlusDialog;
    }

    protected int showFilterPlusDialog() {
        HistoryFilterPlusDialog historyFilterPlusDialog = this.getFilterPlusDialog();
        historyFilterPlusDialog.setModal(true);
        try {
            historyFilterPlusDialog.setAllTags(this.getModel().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        int n = historyFilterPlusDialog.showDialog();
        int n2 = 0;
        HistoryFilter historyFilter = historyFilterPlusDialog.getFilter();
        if (n == 0) {
            this.searchHistory(historyFilter);
            this.logPanel.setFilterStatus(historyFilter);
            n2 = 1;
        } else if (n == 1) {
            this.searchHistory(historyFilter);
            this.logPanel.setFilterStatus(historyFilter);
            n2 = -1;
        }
        return n2;
    }

    private PopupMenuPurgeHistory getPopupMenuPurgeHistory() {
        if (this.popupMenuPurgeHistory == null) {
            this.popupMenuPurgeHistory = new PopupMenuPurgeHistory(this);
        }
        return this.popupMenuPurgeHistory;
    }

    public ManualRequestEditorDialog getResendDialog() {
        if (this.resendDialog == null) {
            this.resendDialog = new ManualHttpRequestEditorDialog(true, "resend", "ui.dialogs.resend");
            this.resendDialog.setTitle(Constant.messages.getString("manReq.resend.popup"));
        }
        return this.resendDialog;
    }

    private PopupMenuExportMessage getPopupMenuExportMessage2() {
        if (this.popupMenuExportMessage2 == null) {
            this.popupMenuExportMessage2 = new PopupMenuExportMessage();
            this.popupMenuExportMessage2.setExtension(this);
        }
        return this.popupMenuExportMessage2;
    }

    private PopupMenuExportResponse getPopupMenuExportResponse2() {
        if (this.popupMenuExportResponse2 == null) {
            this.popupMenuExportResponse2 = new PopupMenuExportResponse();
            this.popupMenuExportResponse2.setExtension(this);
        }
        return this.popupMenuExportResponse2;
    }

    private PopupMenuTag getPopupMenuTag() {
        if (this.popupMenuTag == null) {
            this.popupMenuTag = new PopupMenuTag(this);
        }
        return this.popupMenuTag;
    }

    private PopupMenuNote getPopupMenuNote() {
        if (this.popupMenuNote == null) {
            this.popupMenuNote = new PopupMenuNote(this);
        }
        return this.popupMenuNote;
    }

    private void populateNotesAddDialogAndSetVisible(HistoryReference historyReference, String string) {
        this.dialogNotesAdd.setNote(string);
        this.dialogNotesAdd.setHistoryRef(historyReference);
        this.dialogNotesAdd.setVisible(true);
    }

    public void showNotesAddDialog(HistoryReference historyReference, String string) {
        if (this.dialogNotesAdd == null) {
            this.dialogNotesAdd = new NotesAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogNotesAdd.setPlugin(this);
            this.populateNotesAddDialogAndSetVisible(historyReference, string);
        } else if (!this.dialogNotesAdd.isVisible()) {
            this.populateNotesAddDialogAndSetVisible(historyReference, string);
        }
    }

    public void hideNotesAddDialog() {
        this.dialogNotesAdd.dispose();
    }

    public void showAlertAddDialog(HistoryReference historyReference) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setPlugin(this);
            this.dialogAlertAdd.setVisible(true);
            this.dialogAlertAdd.setHistoryRef(historyReference);
        }
    }

    public void showAlertAddDialog(HttpMessage httpMessage, int n) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setPlugin(this);
            this.dialogAlertAdd.setHttpMessage(httpMessage, n);
            this.dialogAlertAdd.setVisible(true);
        }
    }

    public void showAlertAddDialog(Alert alert) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setPlugin(this);
            this.dialogAlertAdd.setVisible(true);
            this.dialogAlertAdd.setAlert(alert);
        }
    }

    private void populateManageTagsDialogAndSetVisible(HistoryReference historyReference, List<String> list) {
        try {
            this.manageTags.setAllTags(this.getModel().getDb().getTableTag().getAllTags());
        }
        catch (DatabaseException databaseException) {
            this.logger.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
        this.manageTags.setTags(list);
        this.manageTags.setHistoryRef(historyReference);
        this.manageTags.setVisible(true);
    }

    public void showManageTagsDialog(HistoryReference historyReference, List<String> list) {
        if (this.manageTags == null) {
            this.manageTags = new ManageTagsDialog((Frame)this.getView().getMainFrame(), false);
            this.manageTags.setPlugin(this);
            this.populateManageTagsDialogAndSetVisible(historyReference, list);
        } else if (!this.manageTags.isVisible()) {
            this.populateManageTagsDialogAndSetVisible(historyReference, list);
        }
    }

    public void hideManageTagsDialog() {
        this.manageTags.dispose();
    }

    private PopupMenuExportURLs getPopupMenuExportURLs() {
        if (this.popupMenuExportURLs == null) {
            this.popupMenuExportURLs = new PopupMenuExportURLs();
            this.popupMenuExportURLs.setExtension(this);
        }
        return this.popupMenuExportURLs;
    }

    public void showInHistory(HistoryReference historyReference) {
        this.getLogPanel().display(historyReference);
        this.getLogPanel().setTabFocus();
    }

    @Override
    public void sessionAboutToChange(final Session session) {
        if (this.getView() == null || EventQueue.isDispatchThread()) {
            this.historyTableModel.clear();
            this.historyIdToRef.clear();
            if (this.getView() != null) {
                this.getView().displayMessage(null);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionHistory.this.sessionAboutToChange(session);
                    }
                });
            }
            catch (Exception exception) {
                this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    public boolean isShowJustInScope() {
        return this.showJustInScope;
    }

    public void setShowJustInScope(boolean bl) {
        this.showJustInScope = bl;
        if (bl) {
            this.linkWithSitesTree = false;
        }
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(SiteMap siteMap, SiteNode siteNode) {
        SiteNode siteNode2 = null;
        SiteMap siteMap2 = siteMap;
        synchronized (siteMap2) {
            while (siteNode.getChildCount() > 0) {
                try {
                    siteNode2 = (SiteNode)siteNode.getChildAt(0);
                    this.purge(siteMap, siteNode2);
                }
                catch (Exception exception) {
                    this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (siteNode.isRoot()) {
                return;
            }
            this.removeFromHistoryList(siteNode.getHistoryReference());
            if (View.isInitialised()) {
                this.clearLogPanelDisplayQueue();
            }
            ExtensionAlert extensionAlert = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAlert.class);
            if (siteNode.getHistoryReference() != null) {
                ExtensionHistory.deleteAlertsFromExtensionAlert(extensionAlert, siteNode.getHistoryReference());
                siteNode.getHistoryReference().delete();
                siteMap.removeHistoryReference(siteNode.getHistoryReference().getHistoryId());
            }
            while (siteNode.getPastHistoryReference().size() > 0) {
                HistoryReference historyReference = siteNode.getPastHistoryReference().get(0);
                ExtensionHistory.deleteAlertsFromExtensionAlert(extensionAlert, historyReference);
                this.removeFromHistoryList(historyReference);
                if (View.isInitialised()) {
                    this.clearLogPanelDisplayQueue();
                }
                this.delete(historyReference);
                siteNode.getPastHistoryReference().remove(0);
                siteMap.removeHistoryReference(historyReference.getHistoryId());
            }
            siteMap.removeNodeFromParent(siteNode);
        }
    }

    private static void deleteAlertsFromExtensionAlert(ExtensionAlert extensionAlert, HistoryReference historyReference) {
        if (extensionAlert == null) {
            return;
        }
        extensionAlert.deleteHistoryReferenceAlerts(historyReference);
    }

    void setLinkWithSitesTree(boolean bl, String string) {
        this.linkWithSitesTree = bl;
        this.linkWithSitesTreeBaseUri = string;
        if (bl) {
            this.showJustInScope = false;
        }
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    void updateLinkWithSitesTreeBaseUri(String string) {
        this.linkWithSitesTreeBaseUri = string;
        this.searchHistory(this.getFilterPlusDialog().getFilter());
    }

    @Override
    public void sessionScopeChanged(Session session) {
        if (this.getView() != null) {
            this.searchHistory(this.getFilterPlusDialog().getFilter());
        } else {
            this.searchHistory(null);
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    private class AlertEventConsumer
    implements EventConsumer {
        private AlertEventConsumer() {
        }

        @Override
        public void eventReceived(Event event) {
            switch (event.getEventType()) {
                case "alert.added": 
                case "alert.changed": 
                case "alert.removed": {
                    ExtensionHistory.this.notifyHistoryItemChanged(Integer.valueOf(event.getParameters().get("historyId")));
                    break;
                }
                default: {
                    ExtensionHistory.this.notifyHistoryItemsChanged();
                }
            }
        }
    }
}

