/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.keyboard.DialogEditShortcut;
import org.zaproxy.zap.extension.keyboard.ExtensionKeyboard;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcutTableModel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;

public class OptionsKeyboardShortcutPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(OptionsKeyboardShortcutPanel.class);
    private ExtensionKeyboard extension;
    private KeyboardOptionsPanel tkeyboardOptionsPanel;
    private JButton resetButton = null;
    private JButton cheatsheetAction = null;
    private JButton cheatsheetKey = null;
    private boolean reset = false;
    private KeyboardShortcutTableModel keyboardModel = null;

    public OptionsKeyboardShortcutPanel(ExtensionKeyboard extensionKeyboard) {
        this.extension = extensionKeyboard;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("keyboard.options.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.tkeyboardOptionsPanel = new KeyboardOptionsPanel(this.getShortcutModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tkeyboardOptionsPanel, LayoutHelper.getGBC(0, 0, 5, 1.0, 1.0, 1, 21, null));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 1, 1, 0.5, 0.0));
        if (DesktopUtils.canOpenUrlInBrowser()) {
            this.add((Component)this.getCheatsheetAction(), LayoutHelper.getGBC(1, 1, 1, 0.0, 0.0));
            this.add((Component)this.getCheatsheetKey(), LayoutHelper.getGBC(2, 1, 1, 0.0, 0.0));
        }
        this.add((Component)this.getResetButton(), LayoutHelper.getGBC(3, 1, 1, 0.0, 0.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(4, 1, 1, 0.5, 0.0));
    }

    @Override
    public void initParam(Object object) {
        this.setShortcuts(this.extension.getShortcuts());
        this.getCheatsheetAction().setEnabled(API.getInstance().isEnabled());
        this.getCheatsheetKey().setEnabled(API.getInstance().isEnabled());
        this.tkeyboardOptionsPanel.packAll();
    }

    public void setShortcuts(List<KeyboardShortcut> list) {
        this.getShortcutModel().setShortcuts(list);
    }

    public List<KeyboardShortcut> getShortcuts() {
        return this.getShortcutModel().getElements();
    }

    public void addShortcut(KeyboardShortcut keyboardShortcut) {
        this.getShortcutModel().addShortcut(keyboardShortcut);
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton(Constant.messages.getString("keyboard.options.button.reset"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsKeyboardShortcutPanel.this.setShortcuts(OptionsKeyboardShortcutPanel.this.extension.getShortcuts(true));
                    OptionsKeyboardShortcutPanel.this.reset = true;
                }
            });
        }
        return this.resetButton;
    }

    private JButton getCheatsheetAction() {
        if (this.cheatsheetAction == null) {
            this.cheatsheetAction = new JButton(Constant.messages.getString("keyboard.options.button.cheatAction"));
            this.cheatsheetAction.setToolTipText(Constant.messages.getString("keyboard.options.button.cheatAction.tooltip"));
            this.cheatsheetAction.setEnabled(API.getInstance().isEnabled());
            this.cheatsheetAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsKeyboardShortcutPanel.this.extension.displayCheatsheetSortedByAction();
                }
            });
        }
        return this.cheatsheetAction;
    }

    private JButton getCheatsheetKey() {
        if (this.cheatsheetKey == null) {
            this.cheatsheetKey = new JButton(Constant.messages.getString("keyboard.options.button.cheatKey"));
            this.cheatsheetKey.setToolTipText(Constant.messages.getString("keyboard.options.button.cheatKey.tooltip"));
            this.cheatsheetKey.setEnabled(API.getInstance().isEnabled());
            this.cheatsheetKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsKeyboardShortcutPanel.this.extension.displayCheatsheetSortedByKey();
                }
            });
        }
        return this.cheatsheetKey;
    }

    @Override
    public void saveParam(Object object) throws Exception {
        for (KeyboardShortcut keyboardShortcut : this.getShortcutModel().getElements()) {
            boolean bl = keyboardShortcut.isChanged();
            if (this.reset) {
                KeyboardShortcut keyboardShortcut2 = new KeyboardShortcut("temp", "temp", this.extension.getShortcut(keyboardShortcut.getIdentifier()));
                if (!keyboardShortcut.getKeyStrokeString().equals(keyboardShortcut2.getKeyStrokeString())) {
                    bl = true;
                }
            }
            if (!bl) continue;
            logger.debug((Object)("Setting keyboard shortcut for " + keyboardShortcut.getIdentifier() + " to " + keyboardShortcut.getKeyStroke()));
            this.extension.setShortcut(keyboardShortcut.getIdentifier(), keyboardShortcut.getKeyStroke());
        }
        this.extension.getKeyboardParam().setConfigs();
    }

    private KeyboardShortcutTableModel getShortcutModel() {
        if (this.keyboardModel == null) {
            this.keyboardModel = new KeyboardShortcutTableModel();
        }
        return this.keyboardModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.keyboard";
    }

    private static class KeyboardOptionsPanel
    extends MultipleOptionsTablePanel {
        private static final long serialVersionUID = -115340627058929308L;
        private DialogEditShortcut modifyDialog = null;
        private KeyboardShortcutTableModel model;

        public KeyboardOptionsPanel(final KeyboardShortcutTableModel keyboardShortcutTableModel) {
            super(keyboardShortcutTableModel);
            this.model = keyboardShortcutTableModel;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
            this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n = KeyboardOptionsPanel.this.getTable().getSelectedRow()) >= 0) {
                        KeyboardOptionsPanel.this.showModifyDialogue(keyboardShortcutTableModel.getElements().get(KeyboardOptionsPanel.this.getTable().convertRowIndexToModel(n)));
                    }
                }
            });
        }

        protected void packAll() {
            this.getTable().packAll();
        }

        public void showModifyDialogue(KeyboardShortcut keyboardShortcut) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogEditShortcut((Window)View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.init(keyboardShortcut, this.model);
            this.modifyDialog.setVisible(true);
        }
    }
}

