/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.utils.Stats;

public class RegexAutoTagScanner
extends PluginPassiveScanner {
    public static final String TAG_STATS_PREFIX = "stats.tag.";
    protected static final int PATTERN_SCAN = 2;
    private String name = null;
    private String requestUrlRegex = null;
    private String requestHeaderRegex = null;
    private String responseHeaderRegex = null;
    private String responseBodyRegex = null;
    private Pattern requestUrlPattern = null;
    private Pattern requestHeaderPattern = null;
    private Pattern responseHeaderPattern = null;
    private Pattern responseBodyPattern = null;
    private TYPE type = null;
    private String config = null;
    private PassiveScanThread parent = null;

    public RegexAutoTagScanner() {
    }

    public RegexAutoTagScanner(String string, TYPE tYPE, String string2) {
        this.name = string;
        this.type = tYPE;
        this.config = string2;
    }

    public RegexAutoTagScanner(String string, TYPE tYPE, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.name = string;
        this.setRequestUrlRegex(string3);
        this.setRequestHeaderRegex(string4);
        this.setResponseHeaderRegex(string5);
        this.setResponseBodyRegex(string6);
        this.type = tYPE;
        this.config = string2;
        this.setEnabled(bl);
    }

    public RegexAutoTagScanner(RegexAutoTagScanner regexAutoTagScanner) {
        this(regexAutoTagScanner.name, regexAutoTagScanner.type, regexAutoTagScanner.config, regexAutoTagScanner.requestUrlRegex, regexAutoTagScanner.requestHeaderRegex, regexAutoTagScanner.responseHeaderRegex, regexAutoTagScanner.responseBodyRegex, regexAutoTagScanner.isEnabled());
    }

    public Pattern getRequestUrlPattern() {
        return this.requestUrlPattern;
    }

    public Pattern getRequestHeaderPattern() {
        return this.requestHeaderPattern;
    }

    public Pattern getResponseHeaderPattern() {
        return this.responseHeaderPattern;
    }

    public Pattern getResponseBodyPattern() {
        return this.responseBodyPattern;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE tYPE) {
        this.type = tYPE;
    }

    public String getConf() {
        return this.config;
    }

    public void setConf(String string) {
        this.config = string;
    }

    public String getRequestUrlRegex() {
        return this.requestUrlRegex;
    }

    public void setRequestUrlRegex(String string) {
        this.requestUrlRegex = string;
        this.requestUrlPattern = string == null || string.length() == 0 ? null : Pattern.compile(string, 2);
    }

    public String getRequestHeaderRegex() {
        return this.requestHeaderRegex;
    }

    public void setRequestHeaderRegex(String string) {
        this.requestHeaderRegex = string;
        this.requestHeaderPattern = string == null || string.length() == 0 ? null : Pattern.compile(string, 2);
    }

    public String getResponseHeaderRegex() {
        return this.responseHeaderRegex;
    }

    public void setResponseHeaderRegex(String string) {
        this.responseHeaderRegex = string;
        this.responseHeaderPattern = string == null || string.length() == 0 ? null : Pattern.compile(string, 2);
    }

    public String getResponseBodyRegex() {
        return this.responseBodyRegex;
    }

    public void setResponseBodyRegex(String string) {
        this.responseBodyRegex = string;
        this.responseBodyPattern = string == null || string.length() == 0 ? null : Pattern.compile(string, 2);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
        Matcher matcher;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getRequestHeaderPattern() != null && (matcher = this.getRequestHeaderPattern().matcher(httpMessage.getRequestHeader().toString())).find()) {
            this.matched(httpMessage, n);
            return;
        }
        if (this.getRequestUrlPattern() != null && (matcher = this.getRequestUrlPattern().matcher(httpMessage.getRequestHeader().getURI().toString())).find()) {
            this.matched(httpMessage, n);
            return;
        }
    }

    public Alert getAlert(HttpMessage httpMessage) {
        return null;
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        Matcher matcher;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getResponseHeaderPattern() != null && (matcher = this.getResponseHeaderPattern().matcher(httpMessage.getResponseHeader().toString())).find()) {
            this.matched(httpMessage, n);
            return;
        }
        if (this.getResponseBodyPattern() != null && (matcher = this.getResponseBodyPattern().matcher(httpMessage.getResponseBody().toString())).find()) {
            this.matched(httpMessage, n);
            return;
        }
    }

    @Override
    public void setParent(PassiveScanThread passiveScanThread) {
        this.parent = passiveScanThread;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.config == null ? 0 : this.config.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.requestHeaderRegex == null ? 0 : this.requestHeaderRegex.hashCode());
        n = 31 * n + (this.requestUrlRegex == null ? 0 : this.requestUrlRegex.hashCode());
        n = 31 * n + (this.responseBodyRegex == null ? 0 : this.responseBodyRegex.hashCode());
        n = 31 * n + (this.responseHeaderRegex == null ? 0 : this.responseHeaderRegex.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RegexAutoTagScanner regexAutoTagScanner = (RegexAutoTagScanner)object;
        if (this.config == null ? regexAutoTagScanner.config != null : !this.config.equals(regexAutoTagScanner.config)) {
            return false;
        }
        if (this.name == null ? regexAutoTagScanner.name != null : !this.name.equals(regexAutoTagScanner.name)) {
            return false;
        }
        if (this.requestHeaderRegex == null ? regexAutoTagScanner.requestHeaderRegex != null : !this.requestHeaderRegex.equals(regexAutoTagScanner.requestHeaderRegex)) {
            return false;
        }
        if (this.requestUrlRegex == null ? regexAutoTagScanner.requestUrlRegex != null : !this.requestUrlRegex.equals(regexAutoTagScanner.requestUrlRegex)) {
            return false;
        }
        if (this.responseBodyRegex == null ? regexAutoTagScanner.responseBodyRegex != null : !this.responseBodyRegex.equals(regexAutoTagScanner.responseBodyRegex)) {
            return false;
        }
        if (this.responseHeaderRegex == null ? regexAutoTagScanner.responseHeaderRegex != null : !this.responseHeaderRegex.equals(regexAutoTagScanner.responseHeaderRegex)) {
            return false;
        }
        return this.type == regexAutoTagScanner.type;
    }

    private void matched(HttpMessage httpMessage, int n) {
        if (this.tagHistoryType(httpMessage.getHistoryRef().getHistoryType())) {
            this.parent.addTag(n, this.getConf());
        }
        try {
            Stats.incCounter(SessionStructure.getHostName(httpMessage), TAG_STATS_PREFIX + this.getConf());
        }
        catch (URIException uRIException) {
            // empty catch block
        }
    }

    private boolean tagHistoryType(int n) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(n);
    }

    @Override
    public boolean appliesToHistoryType(int n) {
        return true;
    }

    public static enum TYPE {
        ALERT,
        TAG,
        TECH;

    }
}

