/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.gui.BarPanel;
import dguitar.gui.DisplayOptions;
import dguitar.gui.MusicCursor;
import dguitar.gui.MusicCursorPosition;
import dguitar.gui.OptionsDisplay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public abstract class Bar
extends JPanel
implements OptionsDisplay {
    public int TS;
    protected boolean isFirst;
    protected boolean isLast;
    private DisplayOptions displayOptions;
    protected boolean displayTimeSignature;
    protected int minx;
    private String numerator;
    private String denominator;
    protected GPMeasure measure;
    protected BarPanel BP;
    private final Color backGround = Color.WHITE;
    private final Color foreGround = Color.BLACK;

    public Bar(DisplayOptions currentDisplayOptions, BarPanel bp) {
        this.displayOptions = currentDisplayOptions;
        this.BP = bp;
        this.commonConstructor();
    }

    private void commonConstructor() {
        this.setOpaque(true);
        this.setBackground(this.backGround);
        this.setForeground(this.foreGround);
        this.setLayout(null);
        this.measure = null;
        this.isFirst = false;
        this.isLast = false;
        this.setOpaque(true);
        this.displayTimeSignature = true;
    }

    public void setDisplayOptions(DisplayOptions displayOptions) {
        this.displayOptions = displayOptions;
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    public boolean equalTimeSignature(Bar bar) {
        boolean equalTS = false;
        if (bar != null) {
            if (this.measure != null && bar.measure != null) {
                equalTS = this.measure.getNumerator() == bar.measure.getNumerator();
                equalTS = equalTS && this.measure.getDenominator() == bar.measure.getDenominator();
            } else if (this.measure == null && bar.measure == null) {
                equalTS = true;
            }
        }
        return equalTS;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o != null && o.getClass().isInstance(this)) {
            Bar other = (Bar)o;
            equal = this.equalTimeSignature(other);
            if (this.measure != null) {
                equal = equal && this.measure.equals(other.measure);
            }
        }
        return equal;
    }

    public int getTopOffset() {
        return this.displayOptions.TopOffset;
    }

    public void setTopOffset(int topOffset) {
        if (topOffset >= 0) {
            this.displayOptions.TopOffset = topOffset;
        }
    }

    public int getBottomOffset() {
        return this.displayOptions.BottomOffset;
    }

    public void setBottomOffset(int bottomOffset) {
        if (bottomOffset >= 0) {
            this.displayOptions.BottomOffset = bottomOffset;
        }
    }

    public boolean getExtendTop() {
        return this.displayOptions.extendTop;
    }

    public void setExtendTop(boolean value) {
        this.displayOptions.extendTop = value;
    }

    public boolean getExtendBottom() {
        return this.displayOptions.extendBottom;
    }

    public void setExtendBottom(boolean value) {
        this.displayOptions.extendBottom = value;
    }

    public GPMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(GPMeasure m) {
        this.measure = m;
    }

    private int calculateTS(Graphics g) {
        int resp = -80;
        int num = this.measure.getNumerator();
        int den = this.measure.getDenominator();
        if (g == null) {
            int max = Math.max(num, den);
            resp = max <= 9 ? 14 : 22;
        } else {
            this.numerator = "" + num;
            this.denominator = "" + den;
            int dx = g.getFontMetrics(BarPanel.timeSignatureFont).stringWidth(this.numerator);
            int dxAux = g.getFontMetrics(BarPanel.timeSignatureFont).stringWidth(this.denominator);
            resp = Math.max(dxAux, dx);
        }
        return resp;
    }

    private int calculateWidthInc() {
        int incW = 0;
        int d = 6;
        if (this.isFirst) {
            incW = 3;
        }
        if (this.isLast) {
            incW += 2;
        }
        if (this.measure != null) {
            int numRep = this.measure.getNumberOfRepetitions();
            if (!this.isLast && this.measure.hasDoubleBar) {
                incW += 2;
            }
            if (this.measure.repeatStart) {
                if (!this.isFirst) {
                    incW = 3;
                }
                incW += d / 2 + d;
            }
            if (numRep > 0) {
                if (!this.isLast) {
                    incW += 2;
                }
                incW += d / 2 + d;
            }
            if (this.displayTimeSignature) {
                this.TS = this.calculateTS(null);
                incW += this.TS;
            }
        }
        return incW;
    }

    protected void paintMeasure(Graphics g) {
        int y;
        int w;
        int x = 0;
        int maxX = w = this.getWidth() - 1;
        int aboveText = this.displayOptions.TopOffset - 7;
        g.setColor(Color.RED);
        g.setFont(BarPanel.measureNumberFont);
        String aux = "" + this.measure.getNumber();
        g.drawString(aux, 1, aboveText);
        g.setColor(this.getForeground());
        int i = 0;
        while (i < this.BP.LINES) {
            y = this.displayOptions.TopOffset + i * this.displayOptions.LS;
            g.drawLine(x, y, maxX, y);
            ++i;
        }
        y = this.displayOptions.TopOffset;
        if (this.displayOptions.extendTop) {
            y = 0;
        }
        int y2 = this.displayOptions.TopOffset + this.BP.H;
        if (this.displayOptions.extendBottom) {
            y2 += this.displayOptions.BottomOffset;
        }
        this.minx = 0;
        g.drawLine(0, y, 0, y2);
        if (this.isFirst) {
            g.drawLine(1, y, 1, y2);
            g.drawLine(3, y, 3, y2);
            this.minx = 3;
        }
        int dx = 0;
        if (this.isLast) {
            dx = 1;
            g.drawLine(w, y, w, y2);
            g.drawLine(w - dx, y, w - dx, y2);
            g.drawLine(w - dx - 2, y, w - dx - 2, y2);
        }
        if (this.measure != null) {
            int yAux;
            int d = this.displayOptions.LS / 2 + 1;
            int numRep = this.measure.getNumberOfRepetitions();
            if (!this.isLast && this.measure.hasDoubleBar) {
                g.drawLine(w - 2, y, w - 2, y2);
            }
            if (this.measure.repeatStart) {
                if (!this.isFirst) {
                    g.drawLine(1, y, 1, y2);
                    g.drawLine(3, y, 3, y2);
                    this.minx = 3;
                }
                yAux = this.displayOptions.LS * (this.BP.LINES - 2) / 2 + this.displayOptions.TopOffset;
                g.fillOval(this.minx + d / 2, yAux - d / 2 + 1, d, d);
                g.fillOval(this.minx + d / 2, yAux + this.displayOptions.LS - d / 2 + 1, d, d);
                this.minx = this.minx + d / 2 + d;
            }
            if (numRep > 0) {
                if (!this.isLast) {
                    g.drawLine(w, y, w, y2);
                    g.drawLine(w - 2, y, w - 2, y2);
                }
                yAux = this.displayOptions.LS * (this.BP.LINES - 2) / 2 + this.displayOptions.TopOffset;
                g.fillOval(w - 2 - d - d / 2, yAux - d / 2 + 1, d, d);
                g.fillOval(w - 2 - d - d / 2, yAux + this.displayOptions.LS - d / 2 + 1, d, d);
                g.setFont(BarPanel.repeatFont);
                aux = numRep + "x";
                dx = g.getFontMetrics().stringWidth(aux);
                g.drawString(aux, w - dx - 3, aboveText);
            }
            if (this.displayTimeSignature) {
                y = this.BP.H / 2 + this.displayOptions.TopOffset;
                this.minx += 5;
                g.setFont(BarPanel.timeSignatureFont);
                int dy = g.getFontMetrics().getAscent();
                this.TS = this.calculateTS(g);
                g.drawString(this.numerator, this.minx, y - 1);
                g.drawString(this.denominator, this.minx, y + dy - 3);
                this.minx += this.TS;
            }
        }
    }

    public int getHeight() {
        int res = this.displayOptions.TopOffset + this.BP.H + this.displayOptions.BottomOffset;
        return res;
    }

    protected abstract int calculateWidth(int var1);

    public abstract MusicCursorPosition getMusicCursorPosition(int var1);

    public abstract MusicCursorPosition getMusicCursorPosition(MusicCursor var1);

    public abstract MusicCursorPosition snapX(int var1, MusicCursor var2);

    public int getWidth() {
        int inc = this.calculateWidthInc();
        int w = this.calculateWidth(inc);
        return w;
    }

    public Dimension getMinimumSize() {
        Dimension retValue = new Dimension(this.getWidth(), this.getHeight());
        return retValue;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected void paintComponent(Graphics gg) {
        Graphics g = gg.create();
        super.paintComponent(g);
        this.paintMeasure(g);
        g.dispose();
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }
}

