/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class GotoReturnReplacer
extends SimplifiedVisitor
implements InstructionVisitor {
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;

    public GotoReturnReplacer(CodeAttributeEditor codeAttributeEditor) {
        this(codeAttributeEditor, null);
    }

    public GotoReturnReplacer(CodeAttributeEditor codeAttributeEditor, InstructionVisitor instructionVisitor) {
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        byte by = branchInstruction.opcode;
        if (by == -89 || by == -56) {
            int n2 = n + branchInstruction.branchOffset;
            if (!this.codeAttributeEditor.isModified(n) && !this.codeAttributeEditor.isModified(n2)) {
                Instruction instruction = InstructionFactory.create(codeAttribute.code, n2);
                switch (instruction.opcode) {
                    case -84: 
                    case -83: 
                    case -82: 
                    case -81: 
                    case -80: 
                    case -79: {
                        SimpleInstruction simpleInstruction = new SimpleInstruction(instruction.opcode);
                        this.codeAttributeEditor.replaceInstruction(n, simpleInstruction);
                        if (this.extraInstructionVisitor == null) break;
                        this.extraInstructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, n, branchInstruction);
                    }
                }
            }
        }
    }
}

