/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

final class URLSourceImpl
extends Content {
    private static final Map<URL, WeakReference<URLSourceImpl>> urlToSource = new HashMap<URL, WeakReference<URLSourceImpl>>();
    private final URL url;
    private final URI uri;
    private final String name;

    public static URLSourceImpl get(URL url, String name) throws IOException {
        URLSourceImpl source;
        WeakReference<URLSourceImpl> sourceRef = urlToSource.get(url);
        URLSourceImpl uRLSourceImpl = source = sourceRef == null ? null : (URLSourceImpl)sourceRef.get();
        if (source == null) {
            source = new URLSourceImpl(url, name);
            urlToSource.put(url, new WeakReference<URLSourceImpl>(source));
        }
        return source;
    }

    URLSourceImpl(URL url, String name) throws IOException {
        this(url, url.openConnection(), name);
    }

    URLSourceImpl(URL url, URLConnection c, String name) throws IOException {
        this.url = url;
        this.name = name;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Bad URL: " + url, ex);
        }
        this.code = Source.read(new InputStreamReader(c.getInputStream()));
    }

    URLSourceImpl(URL url, String code, String name) throws IOException {
        this.url = url;
        this.name = name;
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException("Bad URL: " + url, ex);
        }
        this.code = code != null ? code : Source.read(new InputStreamReader(url.openStream()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.url.toExternalForm();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    URI getURI() {
        return this.uri;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.code);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    String findMimeType() throws IOException {
        try {
            Path path = Paths.get(this.url.toURI());
            String firstGuess = Files.probeContentType(path);
            if (firstGuess != null) {
                return firstGuess;
            }
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException exception) {
            // empty catch block
        }
        return this.url.openConnection().getContentType();
    }

    @Override
    Object getHashKey() {
        return this.url;
    }
}

