/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

class WindowTableModel
extends AbstractTableModel {
    private static final String PLUGIN_SET_PREFIX = "Plugin: ";
    private static final String CORE_DOCKABLE_SET = "Core";
    private static final String ALL_DOCKABLE_SET = "All";
    private HashMap<String, Vector<Entry>> dockableSets = new HashMap();
    private Vector<Entry> windows;

    WindowTableModel() {
        String[] stringArray;
        Vector<Entry> vector = new Vector<Entry>();
        this.dockableSets.put(ALL_DOCKABLE_SET, vector);
        this.windows = new Vector();
        for (String string : stringArray = DockableWindowManager.getRegisteredDockableWindows()) {
            String string2 = DockableWindowManager.getDockableWindowPluginName(string);
            String string3 = string2 != null ? PLUGIN_SET_PREFIX + string2 : CORE_DOCKABLE_SET;
            Vector<Entry> vector2 = this.dockableSets.get(string3);
            if (vector2 == null) {
                vector2 = new Vector();
                this.dockableSets.put(string3, vector2);
            }
            Entry entry = new Entry(string);
            vector2.add(entry);
            vector.add(entry);
        }
        this.showSet(ALL_DOCKABLE_SET);
    }

    public Vector<String> getDockableSets() {
        Vector<String> vector = new Vector<String>();
        for (String string : this.dockableSets.keySet()) {
            vector.add(string);
        }
        vector.remove(ALL_DOCKABLE_SET);
        vector.remove(CORE_DOCKABLE_SET);
        Collections.sort(vector);
        vector.insertElementAt(CORE_DOCKABLE_SET, 0);
        vector.insertElementAt(ALL_DOCKABLE_SET, 0);
        return vector;
    }

    public void showSet(String string) {
        this.windows = this.dockableSets.get(string);
        Collections.sort(this.windows, new WindowCompare());
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.windows.size();
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        throw new InternalError();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Entry entry = this.windows.elementAt(n);
        switch (n2) {
            case 0: {
                return entry.title;
            }
            case 1: {
                return entry.dockPosition;
            }
        }
        throw new InternalError();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        Entry entry = this.windows.elementAt(n);
        switch (n2) {
            case 1: {
                entry.dockPosition = (String)object;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(n, n);
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return jEdit.getProperty("options.docking.title");
            }
            case 1: {
                return jEdit.getProperty("options.docking.dockPosition");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.windows.size(); ++i) {
            this.windows.elementAt(i).save();
        }
    }

    static class WindowCompare
    implements Comparator<Object> {
        WindowCompare() {
        }

        @Override
        public int compare(Object object, Object object2) {
            Entry entry = (Entry)object;
            Entry entry2 = (Entry)object2;
            return StandardUtilities.compareStrings(entry.title, entry2.title, true);
        }
    }

    static class Entry {
        String name;
        String title;
        String dockPosition;

        Entry(String string) {
            this.name = string;
            this.title = jEdit.getProperty(string + ".title");
            if (this.title == null) {
                this.title = string;
            }
            this.dockPosition = jEdit.getProperty(string + ".dock-position");
            if (this.dockPosition == null) {
                this.dockPosition = "floating";
            }
        }

        void save() {
            jEdit.setProperty(this.name + ".dock-position", this.dockPosition);
        }
    }
}

