/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Tag;

public class TagMap
extends AbstractMap<String, String>
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final String[] EMPTY_TAGS = new String[0];
    private volatile String[] tags;

    public TagMap() {
        this((String[])null);
    }

    public TagMap(Map<String, String> map) {
        this.putAll(map);
    }

    public TagMap(TagMap tagMap) {
        this(tagMap.tags);
    }

    public TagMap(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.tags = EMPTY_TAGS;
        } else {
            if (stringArray.length % 2 != 0) {
                throw new IllegalArgumentException("tags array length needs to be multiple of two.");
            }
            this.tags = stringArray;
        }
    }

    public TagMap(Collection<Tag> collection) {
        for (Tag tag : collection) {
            this.put(tag.getKey(), tag.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new TagEntrySet(this.tags);
    }

    @Override
    public boolean containsKey(Object object) {
        return TagMap.indexOfKey(this.tags, object) >= 0;
    }

    @Override
    public String get(Object object) {
        String[] stringArray = this.tags;
        int n = TagMap.indexOfKey(stringArray, object);
        return n < 0 ? null : stringArray[n + 1];
    }

    @Override
    public boolean containsValue(Object object) {
        String[] stringArray = this.tags;
        for (int i = 1; i < stringArray.length; i += 2) {
            if (!object.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized String put(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        int n = TagMap.indexOfKey(this.tags, string);
        int n2 = this.tags.length;
        if (n < 0) {
            n = n2;
            n2 += 2;
        }
        String[] stringArray = Arrays.copyOf(this.tags, n2);
        String string3 = stringArray[n + 1];
        stringArray[n] = string;
        stringArray[n + 1] = string2;
        this.tags = stringArray;
        return string3;
    }

    @Override
    public synchronized String remove(Object object) {
        int n = TagMap.indexOfKey(this.tags, object);
        if (n < 0) {
            return null;
        }
        String string = this.tags[n + 1];
        int n2 = this.tags.length - 2;
        if (n2 == 0) {
            this.tags = EMPTY_TAGS;
        } else {
            String[] stringArray = new String[n2];
            System.arraycopy(this.tags, 0, stringArray, 0, n);
            System.arraycopy(this.tags, n + 2, stringArray, n, n2 - n);
            this.tags = stringArray;
        }
        return string;
    }

    @Override
    public synchronized void clear() {
        this.tags = EMPTY_TAGS;
    }

    @Override
    public int size() {
        return this.tags.length / 2;
    }

    public List<Tag> getTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (int i = 0; i < this.tags.length; i += 2) {
            arrayList.add(new Tag(this.tags[i], this.tags[i + 1]));
        }
        return arrayList;
    }

    private static int indexOfKey(String[] stringArray, Object object) {
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TagMap[");
        boolean bl = true;
        for (Map.Entry<String, String> entry : this.entrySet()) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
            bl = false;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    String[] getTagsArray() {
        return this.tags;
    }

    private static class TagEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final String[] tags;

        TagEntrySet(String ... stringArray) {
            this.tags = stringArray;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new TagEntryInterator(this.tags);
        }

        @Override
        public int size() {
            return this.tags.length / 2;
        }
    }

    private static class TagEntryInterator
    implements Iterator<Map.Entry<String, String>> {
        private final String[] tags;
        private int currentIndex;

        TagEntryInterator(String ... stringArray) {
            this.tags = stringArray;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.tags.length;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tag tag = new Tag(this.tags[this.currentIndex], this.tags[this.currentIndex + 1]);
            this.currentIndex += 2;
            return tag;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

