/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractToStringProperty<T>
extends AbstractProperty<T> {
    public AbstractToStringProperty(String string, T t) {
        super(string, t);
        this.storeDefaultValue();
    }

    @Override
    public T get() {
        String string = this.getAsString();
        if (!string.isEmpty()) {
            try {
                return this.fromString(string);
            }
            catch (AbstractProperty.InvalidPreferenceValueException invalidPreferenceValueException) {
                Main.warn(BugReport.intercept(invalidPreferenceValueException).put("key", this.key).put("value", string));
            }
        }
        return this.getDefaultValue();
    }

    protected abstract T fromString(String var1);

    @Override
    public boolean put(T t) {
        String string = t == null ? null : this.toString(t);
        return this.getPreferences().put(this.getKey(), string);
    }

    protected abstract String toString(T var1);

    protected String getAsString() {
        Object t = this.getDefaultValue();
        return this.getPreferences().get(this.key, t == null ? "" : this.toString(t));
    }

    public AbstractToStringProperty<T> getSpecialized(String string) {
        return this.getChildProperty(this.getKey() + "." + string);
    }

    protected AbstractToStringProperty<T> getChildProperty(String string) {
        return new ChildProperty(this, string);
    }

    public CachingProperty<T> cached() {
        return new CachingProperty(this);
    }

    public static class ChildProperty<T>
    extends AbstractToStringProperty<T> {
        private final AbstractToStringProperty<T> parent;

        ChildProperty(AbstractToStringProperty<T> abstractToStringProperty, String string) {
            super(string, null);
            CheckParameterUtil.ensureParameterNotNull(abstractToStringProperty, "parent");
            this.parent = abstractToStringProperty;
        }

        @Override
        protected void storeDefaultValue() {
        }

        @Override
        public T getDefaultValue() {
            return this.parent.get();
        }

        @Override
        protected T fromString(String string) {
            return this.parent.fromString(string);
        }

        @Override
        protected String toString(T t) {
            return this.parent.toString(t);
        }

        @Override
        protected void addListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
            super.addListenerImpl(preferenceChangedListener);
            this.parent.addListenerImpl(preferenceChangedListener);
        }

        @Override
        protected void addWeakListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
            super.addWeakListenerImpl(preferenceChangedListener);
            this.parent.addWeakListenerImpl(preferenceChangedListener);
        }

        @Override
        protected void removeListenerImpl(Preferences.PreferenceChangedListener preferenceChangedListener) {
            super.removeListenerImpl(preferenceChangedListener);
            this.parent.removeListenerImpl(preferenceChangedListener);
        }

        @Override
        public CachingProperty<T> cached() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
    }
}

