/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.date.DateUtils;

public class DateEditorWithSlider
extends JPanel {
    private final JSpinner spinner;
    private final JSlider slider;
    private Date dateMin;
    private Date dateMax;
    private static final int MAX_SLIDER = 300;
    private boolean watchSlider = true;
    private final transient List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public DateEditorWithSlider(String string) {
        super(new GridBagLayout());
        this.spinner = new JSpinner(new SpinnerDateModel());
        String string2 = ((SimpleDateFormat)DateUtils.getDateFormat(2)).toPattern();
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.spinner, string2);
        this.spinner.setEditor(dateEditor);
        this.spinner.setPreferredSize(new Dimension(this.spinner.getPreferredSize().width + 5, this.spinner.getPreferredSize().height));
        this.slider = new JSlider(0, 300);
        this.spinner.addChangeListener(changeEvent -> {
            Date date;
            int n;
            int n2 = this.slider.getValue();
            if (n2 != (n = this.intFromDate(date = (Date)this.spinner.getValue()))) {
                this.watchSlider = false;
                this.slider.setValue(n);
                this.watchSlider = true;
            }
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        });
        this.slider.addChangeListener(changeEvent -> {
            Date date;
            if (!this.watchSlider) {
                return;
            }
            Date date2 = (Date)this.spinner.getValue();
            if (!date2.equals(date = this.dateFromInt(this.slider.getValue()))) {
                this.spinner.setValue(date);
            }
        });
        this.add((Component)new JLabel(string), GBC.std());
        this.add((Component)this.spinner, GBC.std().insets(10, 0, 0, 0));
        this.add((Component)this.slider, GBC.eol().insets(10, 0, 0, 0).fill(2));
        this.dateMin = new Date(0L);
        this.dateMax = new Date();
    }

    protected Date dateFromInt(int n) {
        double d = 1.0 * (double)n / 300.0;
        return new Date((long)((double)this.dateMax.getTime() * d + (double)this.dateMin.getTime() * (1.0 - d)));
    }

    protected int intFromDate(Date date) {
        return (int)(300.0 * (double)(date.getTime() - this.dateMin.getTime()) / (double)(this.dateMax.getTime() - this.dateMin.getTime()));
    }

    public void setRange(Date date, Date date2) {
        this.dateMin = date;
        this.dateMax = date2;
    }

    public void setDate(Date date) {
        this.spinner.setValue(date);
    }

    public Date getDate() {
        return (Date)this.spinner.getValue();
    }

    public void addDateListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeDateListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            component.setEnabled(bl);
        }
    }
}

