/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.StreamProgressUpdater;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ProgressInputStream
extends InputStream {
    private final StreamProgressUpdater updater;
    private final InputStream in;

    public ProgressInputStream(InputStream inputStream, long l, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "in");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.updater = new StreamProgressUpdater(l, progressMonitor, I18n.tr("Downloading data...", new Object[0]));
        this.in = inputStream;
    }

    public ProgressInputStream(URLConnection uRLConnection, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 1);
        progressMonitor.indeterminateSubTask(null);
        try {
            this.in = uRLConnection.getInputStream();
            this.updater = new StreamProgressUpdater(uRLConnection.getContentLength(), progressMonitor, I18n.tr("Downloading data...", new Object[0]));
        }
        catch (IOException iOException) {
            progressMonitor.finishTask();
            if (uRLConnection.getHeaderField("Error") != null) {
                throw new OsmTransferException(I18n.tr(uRLConnection.getHeaderField("Error"), new Object[0]), iOException);
            }
            throw new OsmTransferException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.updater.finishTask();
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.updater.advanceTicker(n3);
        } else {
            this.updater.finishTask();
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.updater.advanceTicker(1);
        } else {
            this.updater.finishTask();
        }
        return n;
    }
}

