/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class IfParseNode
extends ParseNode {
    private final ParseNode condition;
    private final ParseNode thenBody;
    private final ParseNode elseBody;

    public IfParseNode(ISourcePosition position, ParseNode condition, ParseNode thenBody, ParseNode elseBody) {
        super(position, condition.containsVariableAssignment || thenBody != null && thenBody.containsVariableAssignment || elseBody != null && elseBody.containsVariableAssignment);
        assert (condition != null) : "condition is not null";
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.IFNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public ParseNode getCondition() {
        return this.condition;
    }

    public ParseNode getElseBody() {
        return this.elseBody;
    }

    public ParseNode getThenBody() {
        return this.thenBody;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.condition, this.thenBody, this.elseBody);
    }
}

