/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFile;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadServiceResourceInputStream;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.lexer.ByteListLexerSource;
import org.jruby.truffle.parser.lexer.GetsLexerSource;
import org.jruby.truffle.parser.lexer.LexerSource;
import org.jruby.truffle.parser.lexer.SyntaxException;
import org.jruby.truffle.parser.parser.ParserConfiguration;
import org.jruby.truffle.parser.parser.RubyParser;
import org.jruby.truffle.parser.parser.RubyParserResult;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.util.ByteList;

public class Parser {
    private final RubyContext context;
    private volatile long totalTime;
    private volatile int totalBytes;

    public Parser(RubyContext context) {
        this.context = context;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public ParseNode parse(String file, ByteList content, DynamicScope blockScope, ParserConfiguration configuration) {
        configuration.setDefaultEncoding(content.getEncoding());
        RubyArray list = this.getLines(configuration, this.context.getJRubyRuntime(), file);
        ByteListLexerSource lexerSource = new ByteListLexerSource(file, configuration.getLineNumber(), content, list);
        return this.parse(file, lexerSource, blockScope, configuration);
    }

    public ParseNode parse(String file, byte[] content, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyArray list = this.getLines(configuration, this.context.getJRubyRuntime(), file);
        ByteList in = new ByteList(content, configuration.getDefaultEncoding());
        ByteListLexerSource lexerSource = new ByteListLexerSource(file, configuration.getLineNumber(), in, list);
        return this.parse(file, lexerSource, blockScope, configuration);
    }

    public ParseNode parse(String file, InputStream content, DynamicScope blockScope, ParserConfiguration configuration) {
        if (content instanceof LoadServiceResourceInputStream) {
            return this.parse(file, ((LoadServiceResourceInputStream)content).getBytes(), blockScope, configuration);
        }
        RubyArray list = this.getLines(configuration, this.context.getJRubyRuntime(), file);
        Object io = content instanceof FileInputStream ? new RubyFile(this.context.getJRubyRuntime(), file, ((FileInputStream)content).getChannel()) : RubyIO.newIO((Ruby)this.context.getJRubyRuntime(), (Channel)Channels.newChannel(content));
        GetsLexerSource lexerSource = new GetsLexerSource(file, configuration.getLineNumber(), (IRubyObject)io, list, configuration.getDefaultEncoding());
        return this.parse(file, lexerSource, blockScope, configuration);
    }

    public ParseNode parse(String file, LexerSource lexerSource, DynamicScope blockScope, ParserConfiguration configuration) {
        RubyParserResult result;
        if (blockScope != null) {
            configuration.parseAsBlock(blockScope);
        }
        long startTime = System.nanoTime();
        RubyParser parser = new RubyParser(this.context, lexerSource, (IRubyWarnings)this.context.getJRubyRuntime().getWarnings());
        try {
            result = parser.parse(configuration);
            if (parser.lexer.isEndSeen() && configuration.isSaveData()) {
                IRubyObject verbose = this.context.getJRubyRuntime().getVerbose();
                this.context.getJRubyRuntime().setVerbose(this.context.getJRubyRuntime().getNil());
                this.context.getJRubyRuntime().defineGlobalConstant("DATA", lexerSource.getRemainingAsIO());
                this.context.getJRubyRuntime().setVerbose(verbose);
            }
        }
        catch (IOException e) {
            throw this.context.getJRubyRuntime().newSyntaxError("Problem reading source: " + e);
        }
        catch (SyntaxException e) {
            switch (e.getPid()) {
                case UNKNOWN_ENCODING: 
                case NOT_ASCII_COMPATIBLE: {
                    throw this.context.getJRubyRuntime().newArgumentError(e.getMessage());
                }
            }
            StringBuilder buffer = new StringBuilder(100);
            buffer.append(e.getFile()).append(':');
            buffer.append(e.getLine() + 1).append(": ");
            buffer.append(e.getMessage());
            throw this.context.getJRubyRuntime().newSyntaxError(buffer.toString());
        }
        if (result.getScope() != null) {
            result.getScope().growIfNeeded();
        }
        ParseNode ast = result.getAST();
        this.totalTime += System.nanoTime() - startTime;
        this.totalBytes += lexerSource.getOffset();
        return ast;
    }

    private RubyArray getLines(ParserConfiguration configuration, Ruby runtime, String file) {
        RubyArray list = null;
        IRubyObject scriptLines = runtime.getObject().getConstantAt("SCRIPT_LINES__");
        if (!configuration.isEvalParse() && scriptLines != null && scriptLines instanceof RubyHash) {
            list = runtime.newArray();
            ((RubyHash)scriptLines).op_aset(runtime.getCurrentContext(), (IRubyObject)runtime.newString(file), (IRubyObject)list);
        }
        return list;
    }
}

