/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Arrays;
import org.jruby.RubyFixnum;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.MultiBranchInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class BSwitchInstr
extends MultiBranchInstr {
    private final int[] jumps;
    private Operand operand;
    private final Label rubyCase;
    private final Label[] targets;
    private final Label elseTarget;

    public BSwitchInstr(int[] jumps, Operand operand, Label rubyCase, Label[] targets, Label elseTarget) {
        super(Operation.B_SWITCH);
        assert (BSwitchInstr.jumpsAreSorted(jumps));
        this.jumps = jumps;
        this.operand = operand;
        this.rubyCase = rubyCase;
        this.targets = targets;
        this.elseTarget = elseTarget;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.operand};
    }

    public Operand getCaseOperand() {
        return this.operand;
    }

    public int[] getJumps() {
        return this.jumps;
    }

    public Label getRubyCaseLabel() {
        return this.rubyCase;
    }

    public Label[] getTargets() {
        return this.targets;
    }

    public Label getElseTarget() {
        return this.elseTarget;
    }

    @Override
    public void setOperand(int i2, Operand operand) {
        assert (i2 == 0);
        this.operand = operand;
    }

    @Override
    public Instr clone(CloneInfo info) {
        Operand operand = this.operand.cloneForInlining(info);
        Label rubyCase = info.getRenamedLabel(this.rubyCase);
        Label[] targets = new Label[this.targets.length];
        for (int i2 = 0; i2 < targets.length; ++i2) {
            targets[i2] = info.getRenamedLabel(this.targets[i2]);
        }
        Label elseTarget = info.getRenamedLabel(this.elseTarget);
        return new BSwitchInstr(this.jumps, operand, rubyCase, targets, elseTarget);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.jumps);
        e.encode(this.operand);
        e.encode(this.rubyCase);
        e.encode(this.targets);
        e.encode(this.elseTarget);
    }

    public static BSwitchInstr decode(IRReaderDecoder d) {
        return new BSwitchInstr(d.decodeIntArray(), d.decodeOperand(), d.decodeLabel(), d.decodeLabelArray(), d.decodeLabel());
    }

    @Override
    public int interpretAndGetNewIPC(ThreadContext context, DynamicScope currDynScope, StaticScope currScope, IRubyObject self2, Object[] temp, int ipc) {
        Object result2 = this.operand.retrieve(context, self2, currScope, currDynScope, temp);
        if (!(result2 instanceof RubyFixnum)) {
            return this.rubyCase.getTargetPC();
        }
        int value2 = ((RubyFixnum)result2).getIntValue();
        int index2 = Arrays.binarySearch(this.jumps, value2);
        if (index2 < 0) {
            return this.elseTarget.getTargetPC();
        }
        return this.targets[index2].getTargetPC();
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BSwitchInstr(this);
    }

    @Override
    public Label[] getJumpTargets() {
        Label[] jumpTargets = new Label[this.targets.length + 2];
        jumpTargets[0] = this.rubyCase;
        System.arraycopy(this.targets, 0, jumpTargets, 1, this.targets.length);
        jumpTargets[jumpTargets.length - 1] = this.elseTarget;
        return jumpTargets;
    }

    private static boolean jumpsAreSorted(int[] jumps) {
        int[] jumps2 = (int[])jumps.clone();
        Arrays.sort(jumps2);
        return Arrays.equals(jumps, jumps2);
    }
}

