/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

public class ManyVarsDynamicScope
extends DynamicScope {
    private IRubyObject[] variableValues;
    public static final MethodHandle CONSTRUCTOR;

    public ManyVarsDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
        this.allocate();
    }

    private void allocate() {
        if (this.variableValues == null) {
            int size2 = this.staticScope.getNumberOfVariables();
            this.variableValues = new IRubyObject[size2];
        }
    }

    @Override
    public IRubyObject[] getValues() {
        return this.variableValues;
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        this.assertGetValue(offset2, depth);
        return this.variableValues[offset2];
    }

    @Override
    public IRubyObject getValueDepthZero(int offset2) {
        return this.variableValues[offset2];
    }

    @Override
    public IRubyObject getValueZeroDepthZero() {
        return this.variableValues[0];
    }

    @Override
    public IRubyObject getValueOneDepthZero() {
        return this.variableValues[1];
    }

    @Override
    public IRubyObject getValueTwoDepthZero() {
        return this.variableValues[2];
    }

    @Override
    public IRubyObject getValueThreeDepthZero() {
        return this.variableValues[3];
    }

    @Override
    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        this.assertGetValueDepthZeroOrNil(offset2);
        IRubyObject value2 = this.variableValues[offset2];
        return value2 == null ? this.setValueDepthZero(nil, offset2) : value2;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueZeroDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[0];
        return value2 == null ? this.setValueZeroDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueOneDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[1];
        return value2 == null ? this.setValueOneDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueTwoDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[2];
        return value2 == null ? this.setValueTwoDepthZero(nil) : value2;
    }

    @Override
    public IRubyObject getValueThreeDepthZeroOrNil(IRubyObject nil) {
        this.assertGetValueThreeDepthZeroOrNil();
        IRubyObject value2 = this.variableValues[3];
        return value2 == null ? this.setValueThreeDepthZero(nil) : value2;
    }

    @Override
    public void setValueVoid(IRubyObject value2, int offset2, int depth) {
        if (depth > 0) {
            this.assertParent();
            this.parent.setValueVoid(value2, offset2, depth - 1);
        } else {
            this.assertSetValue(offset2, value2);
            this.setValueDepthZeroVoid(value2, offset2);
        }
    }

    @Override
    public void setValueDepthZeroVoid(IRubyObject value2, int offset2) {
        this.assertSetValueDepthZero(offset2, value2);
        this.variableValues[offset2] = value2;
    }

    @Override
    public void setValueZeroDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueZeroDepthZero(value2);
        this.variableValues[0] = value2;
    }

    @Override
    public void setValueOneDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueOneDepthZero(value2);
        this.variableValues[1] = value2;
    }

    @Override
    public void setValueTwoDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueTwoDepthZero(value2);
        this.variableValues[2] = value2;
    }

    @Override
    public void setValueThreeDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[3] = value2;
    }

    @Override
    public void setValueFourDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[4] = value2;
    }

    @Override
    public void setValueFiveDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[5] = value2;
    }

    @Override
    public void setValueSixDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[6] = value2;
    }

    @Override
    public void setValueSevenDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[7] = value2;
    }

    @Override
    public void setValueEightDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[8] = value2;
    }

    @Override
    public void setValueNineDepthZeroVoid(IRubyObject value2) {
        this.assertSetValueThreeDepthZero(value2);
        this.variableValues[9] = value2;
    }

    @Override
    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            Object[] values2 = new IRubyObject[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                ArraySupport.copy(this.variableValues, 0, values2, 0, dynamicSize);
            }
            this.variableValues = values2;
        }
    }

    private void assertGetValue(int offset2, int depth) {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && offset2 < values2.length) : "No variables or index to big for getValue off: " + offset2 + ", Dep: " + depth + ", O: " + this;
    }

    private void assertGetValueDepthZeroOrNil(int offset2) {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && offset2 < values2.length) : "No variables or index too big for getValue off: " + offset2 + ", Dep: " + 0 + ", O: " + this;
    }

    private void assertGetValueZeroDepthZeroOrNil() {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && 0 < values2.length) : "No variables or index to big for getValue off: 0, Dep: 0, O: " + this;
    }

    private void assertGetValueOneDepthZeroOrNil() {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && 1 < values2.length) : "No variables or index to big for getValue off: 1, Dep: 0, O: " + this;
    }

    private void assertGetValueTwoDepthZeroOrNil() {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && 3 < values2.length) : "No variables or index to big for getValue off: 3, Dep: 0, O: " + this;
    }

    private void assertGetValueThreeDepthZeroOrNil() {
        IRubyObject[] values2 = this.variableValues;
        assert (values2 != null && 2 < values2.length) : "No variables or index to big for getValue off: 2, Dep: 0, O: " + this;
    }

    private void assertParent() {
        assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
    }

    private void assertSetValue(int offset2, IRubyObject value2) {
        assert (offset2 < this.variableValues.length) : "Setting " + offset2 + " to " + value2 + ", O: " + this;
    }

    private void assertSetValueDepthZero(int offset2, IRubyObject value2) {
        assert (offset2 < this.variableValues.length) : "Setting " + offset2 + " to " + value2 + ", O: " + this;
    }

    private void assertSetValueZeroDepthZero(IRubyObject value2) {
        assert (0 < this.variableValues.length) : "Setting 0 to " + value2 + ", O: " + this;
    }

    private void assertSetValueOneDepthZero(IRubyObject value2) {
        assert (1 < this.variableValues.length) : "Setting 1 to " + value2 + ", O: " + this;
    }

    private void assertSetValueThreeDepthZero(IRubyObject value2) {
        assert (3 < this.variableValues.length) : "Setting 3 to " + value2 + ", O: " + this;
    }

    private void assertSetValueTwoDepthZero(IRubyObject value2) {
        assert (2 < this.variableValues.length) : "Setting 2 to " + value2 + ", O: " + this;
    }

    @Override
    @Deprecated
    public DynamicScope cloneScope() {
        return new ManyVarsDynamicScope(this.staticScope, this.parent);
    }

    static {
        try {
            CONSTRUCTOR = MethodHandles.publicLookup().findConstructor(ManyVarsDynamicScope.class, MethodType.methodType(Void.TYPE, StaticScope.class, DynamicScope.class)).asType(MethodType.methodType(DynamicScope.class, StaticScope.class, DynamicScope.class));
        }
        catch (Exception e) {
            throw new RuntimeException("BUG: could not initialize constructor handle");
        }
    }
}

