/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.array.ArrayLiteralNode;
import org.jruby.truffle.core.array.ArraySliceNodeGen;
import org.jruby.truffle.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.core.cast.SplatCastNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.MissingKeywordArgumentNode;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadKeywordArgumentNode;
import org.jruby.truffle.language.arguments.ReadKeywordRestArgumentNode;
import org.jruby.truffle.language.arguments.ReadOptionalArgumentNode;
import org.jruby.truffle.language.arguments.ReadPostArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadRestArgumentNode;
import org.jruby.truffle.language.arguments.RunBlockKWArgsHelperNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.IfNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.locals.WriteLocalVariableNode;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.ParameterCollector;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.ArrayParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.BlockArgParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.KeywordArgParseNode;
import org.jruby.truffle.parser.ast.KeywordRestArgParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.NilImplicitParseNode;
import org.jruby.truffle.parser.ast.OptArgParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RequiredKeywordArgumentValueParseNode;
import org.jruby.truffle.parser.ast.RestArgParseNode;
import org.jruby.truffle.parser.ast.StarParseNode;
import org.jruby.truffle.parser.ast.VCallParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class LoadArgumentsTranslator
extends Translator {
    private final boolean isProc;
    private final BodyTranslator methodBodyTranslator;
    private final Deque<ArraySlot> arraySlotStack = new ArrayDeque<ArraySlot>();
    private int required;
    private int index;
    private int indexFromEnd = 1;
    private State state;
    private boolean hasKeywordArguments;
    private List<String> excludedKeywords = new ArrayList<String>();
    private boolean firstOpt = false;
    private ArgsParseNode argsNode;

    public LoadArgumentsTranslator(Node currentNode, RubyContext context, Source source, boolean isProc, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.isProc = isProc;
        this.methodBodyTranslator = methodBodyTranslator;
    }

    @Override
    public RubyNode visitArgsNode(ArgsParseNode node) {
        int preCount;
        boolean useHelper;
        this.argsNode = node;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        sequence.add(LoadArgumentsTranslator.loadSelf(this.context, this.methodBodyTranslator.getEnvironment()));
        ParseNode[] args = node.getArgs();
        boolean bl = useHelper = this.useArray() && node.hasKeyRest();
        if (useHelper) {
            DynamicObject keyRestNameOrNil;
            sequence.add(node.getKeyRest().accept(this));
            if (node.hasKeyRest()) {
                String name = node.getKeyRest().getName();
                this.methodBodyTranslator.getEnvironment().declareVar(name);
                keyRestNameOrNil = this.context.getSymbolTable().getSymbol(name);
            } else {
                keyRestNameOrNil = this.context.getCoreLibrary().getNilObject();
            }
            sequence.add(new IfNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.loadArray(sourceSection)), new RunBlockKWArgsHelperNode(this.arraySlotStack.peek().getArraySlot(), keyRestNameOrNil)));
        }
        if ((preCount = node.getPreCount()) > 0) {
            this.state = State.PRE;
            this.index = 0;
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept(this));
                ++this.index;
                ++this.required;
            }
        }
        this.hasKeywordArguments = node.hasKwargs();
        int optArgCount = node.getOptionalArgsCount();
        if (optArgCount > 0) {
            this.state = State.OPT;
            this.index = this.argsNode.getPreCount();
            int optArgIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgCount; ++i) {
                this.firstOpt = i == 0;
                sequence.add(args[optArgIndex + i].accept(this));
                ++this.index;
            }
        }
        if (node.getRestArgNode() != null) {
            this.methodBodyTranslator.getEnvironment().hasRestParameter = true;
            sequence.add(node.getRestArgNode().accept(this));
        }
        int postCount = node.getPostCount();
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            ParseNode[] children = node.getPost().children();
            this.index = node.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> noRestSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            ParseNode[] children = node.getPost().children();
            this.index = node.getPreCount() + node.getOptionalArgsCount();
            for (int i = 0; i < children.length; ++i) {
                noRestSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode noRest = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, noRestSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (postCount > 0) {
            this.state = State.POST;
            this.index = -1;
            if (!this.useArray() && this.hasKeywordArguments) {
                --this.index;
            }
            int postIndex = node.getPostIndex();
            for (int i = postCount - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add(args[postIndex + i].accept(this));
                ++this.required;
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, notNilAtLeastAsLargeSequence);
        if (this.useArray()) {
            if (node.getPreCount() == 0 || node.hasRestArg()) {
                sequence.add(new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.loadArray(sourceSection)), notNilAtLeastAsLarge, notNilSmaller));
            } else {
                sequence.add(noRest);
            }
        } else {
            sequence.add(notNilAtLeastAsLarge);
        }
        if (this.hasKeywordArguments) {
            int keywordIndex = node.getKeywordsIndex();
            int keywordCount = node.getKeywordCount();
            for (int i = 0; i < keywordCount; ++i) {
                sequence.add(args[keywordIndex + i].accept(this));
            }
        }
        if (node.getKeyRest() != null && !useHelper) {
            sequence.add(node.getKeyRest().accept(this));
        }
        if (node.getBlock() != null) {
            sequence.add(node.getBlock().accept(this));
        }
        return LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, sequence);
    }

    @Override
    public RubyNode visitKeywordRestArgNode(KeywordRestArgParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.context, fullSourceSection, this.required, this.excludedKeywords.toArray(new String[this.excludedKeywords.size()]));
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot(node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, (RubyNode)readNode);
    }

    @Override
    public RubyNode visitKeywordArgNode(KeywordArgParseNode node) {
        String name;
        AssignableParseNode asgnNode;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ParseNode firstChild = node.childNodes().get(0);
        if (firstChild instanceof LocalAsgnParseNode) {
            asgnNode = (LocalAsgnParseNode)firstChild;
            name = ((LocalAsgnParseNode)firstChild).getName();
        } else if (firstChild instanceof DAsgnParseNode) {
            asgnNode = (DAsgnParseNode)firstChild;
            name = ((DAsgnParseNode)firstChild).getName();
        } else {
            throw new UnsupportedOperationException("unsupported keyword arg " + node);
        }
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot(name);
        RubyNode defaultValue = asgnNode.getValueNode() instanceof RequiredKeywordArgumentValueParseNode ? new MissingKeywordArgumentNode(name) : this.translateNodeOrNil(sourceSection, asgnNode.getValueNode());
        this.excludedKeywords.add(name);
        ReadKeywordArgumentNode readNode = new ReadKeywordArgumentNode(this.context, fullSourceSection, this.required, name, defaultValue);
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, (RubyNode)readNode);
    }

    @Override
    public RubyNode visitArgumentNode(ArgumentParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode readNode = this.readArgument(sourceSection);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot(node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, readNode);
    }

    private RubyNode readArgument(RubySourceSection sourceSection) {
        if (this.useArray()) {
            return PrimitiveArrayNodeFactory.read(this.context, sourceSection.toSourceSection(this.source), this.loadArray(sourceSection), this.index);
        }
        if (this.state == State.PRE) {
            return new ProfileArgumentNode(new ReadPreArgumentNode(this.index, this.isProc ? MissingArgumentBehavior.NIL : MissingArgumentBehavior.RUNTIME_ERROR));
        }
        if (this.state == State.POST) {
            return new ReadPostArgumentNode(-this.index);
        }
        throw new IllegalStateException();
    }

    @Override
    public RubyNode visitRestArgNode(RestArgParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (this.argsNode == null) {
            throw new IllegalStateException("No arguments node visited");
        }
        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
        int to = -this.argsNode.getPostCount();
        RubyNode readNode = this.useArray() ? ArraySliceNodeGen.create(this.context, fullSourceSection, from, to, this.loadArray(sourceSection)) : new ReadRestArgumentNode(this.context, fullSourceSection, from, -to, this.hasKeywordArguments, this.required);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot(node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, readNode);
    }

    @Override
    public RubyNode visitBlockArgNode(BlockArgParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ReadBlockNode readNode = new ReadBlockNode(this.context.getCoreLibrary().getNilObject());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot(node.getName());
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, (RubyNode)readNode);
    }

    @Override
    public RubyNode visitOptArgNode(OptArgParseNode node) {
        return node.getValue().accept(this);
    }

    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnParseNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    private RubyNode translateLocalAssignment(ISourcePosition sourcePosition, String name, ParseNode valueNode) {
        RubyNode readNode;
        RubySourceSection sourceSection = this.translate(sourcePosition);
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot(name);
        if (this.indexFromEnd == 1) {
            if (valueNode instanceof NilImplicitParseNode) {
                readNode = this.useArray() ? PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.loadArray(sourceSection), this.index) : this.readArgument(sourceSection);
            } else {
                String calledName;
                RubyNode defaultValue = valueNode instanceof VCallParseNode ? ((calledName = ((VCallParseNode)valueNode).getName()).equals(name) ? new ReadLocalVariableNode(this.context, fullSourceSection, LocalVariableType.FRAME_LOCAL, slot) : valueNode.accept(this)) : valueNode.accept(this);
                if (this.argsNode == null) {
                    throw new IllegalStateException("No arguments node visited");
                }
                int minimum = this.index + 1 + this.argsNode.getPostCount();
                if (this.useArray()) {
                    readNode = new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(minimum, this.loadArray(sourceSection)), PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.loadArray(sourceSection), this.index), defaultValue);
                } else {
                    ReadRestArgumentNode readRest;
                    boolean considerRejectedKWArgs;
                    if (this.argsNode.hasKwargs()) {
                        ++minimum;
                    }
                    if (this.firstOpt && this.hasKeywordArguments) {
                        considerRejectedKWArgs = true;
                        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
                        int to = -this.argsNode.getPostCount();
                        readRest = new ReadRestArgumentNode(this.context, fullSourceSection, from, -to, this.hasKeywordArguments, this.required);
                    } else {
                        considerRejectedKWArgs = false;
                        readRest = null;
                    }
                    readNode = new ReadOptionalArgumentNode(this.context, fullSourceSection, this.index, minimum, considerRejectedKWArgs, this.argsNode.hasKwargs(), this.required, readRest, defaultValue);
                }
            }
        } else {
            readNode = ArraySliceNodeGen.create(this.context, fullSourceSection, this.index, this.indexFromEnd, this.loadArray(sourceSection));
        }
        return WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, slot, readNode);
    }

    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        if (node.size() == 1 && node.get(0) instanceof MultipleAsgnParseNode) {
            return node.children()[0].accept(this);
        }
        return this.defaultVisit(node);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        int arrayIndex = this.index;
        String arrayName = this.methodBodyTranslator.getEnvironment().allocateLocalTemp("destructure");
        FrameSlot arraySlot = this.methodBodyTranslator.getEnvironment().declareVar(arrayName);
        this.pushArraySlot(arraySlot);
        List<Object> childNodes = node.childNodes().get(0) == null ? Collections.emptyList() : node.childNodes().get(0).childNodes();
        ArrayList<RubyNode> notNilSmallerSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (ParseNode child : node.getPre().children()) {
                notNilSmallerSequence.add(child.accept(this));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilSmallerSequence.add(node.getRest().accept(this));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            ParseNode[] children = node.getPost().children();
            this.index = node.getPreCount();
            for (int i = 0; i < children.length; ++i) {
                notNilSmallerSequence.add(children[i].accept(this));
                ++this.index;
            }
        }
        RubyNode notNilSmaller = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, notNilSmallerSequence);
        ArrayList<RubyNode> notNilAtLeastAsLargeSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (ParseNode parseNode : node.getPre().children()) {
                notNilAtLeastAsLargeSequence.add(parseNode.accept(this));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilAtLeastAsLargeSequence.add(node.getRest().accept(this));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            ParseNode[] children = node.getPost().children();
            this.index = -1;
            for (int i = children.length - 1; i >= 0; --i) {
                notNilAtLeastAsLargeSequence.add(children[i].accept(this));
                --this.index;
            }
        }
        RubyNode notNilAtLeastAsLarge = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, notNilAtLeastAsLargeSequence);
        this.popArraySlot(arraySlot);
        ArrayList<RubyNode> nilSequence = new ArrayList<RubyNode>();
        ParameterCollector parametersToClearCollector = new ParameterCollector();
        if (node.getPre() != null) {
            for (ParseNode parseNode : node.getPre().children()) {
                parseNode.accept(parametersToClearCollector);
            }
        }
        if (node.getRest() != null) {
            if (node.getRest() instanceof INameNode) {
                String string = ((INameNode)((Object)node.getRest())).getName();
                if (node.getPreCount() == 0 && node.getPostCount() == 0) {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, this.source, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.context, sourceSection, new RubyNode[]{new NilLiteralNode(this.context, fullSourceSection, true)})));
                } else {
                    nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(string, this.source, sourceSection).makeWriteNode(ArrayLiteralNode.create(this.context, sourceSection, new RubyNode[0])));
                }
            } else if (!(node.getRest() instanceof StarParseNode)) {
                throw new UnsupportedOperationException("unsupported rest node " + node.getRest());
            }
        }
        if (node.getPost() != null) {
            for (ParseNode parseNode : node.getPost().children()) {
                parseNode.accept(parametersToClearCollector);
            }
        }
        for (String parameterToClear : parametersToClearCollector.getParameters()) {
            nilSequence.add(this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(parameterToClear, this.source, sourceSection).makeWriteNode(this.nilNode(this.source, sourceSection)));
        }
        if (!childNodes.isEmpty()) {
            this.index = arrayIndex;
            nilSequence.add(((ParseNode)childNodes.get(0)).accept(this));
        }
        RubyNode rubyNode = LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, nilSequence);
        return LoadArgumentsTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(WriteLocalVariableNode.createWriteLocalVariableNode(this.context, fullSourceSection, arraySlot, (RubyNode)SplatCastNodeGen.create(this.context, fullSourceSection, SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.readArgument(sourceSection))), new IfElseNode(new IsNilNode(this.context, fullSourceSection, new ReadLocalVariableNode(this.context, fullSourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)), rubyNode, new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), new ReadLocalVariableNode(this.context, fullSourceSection, LocalVariableType.FRAME_LOCAL, arraySlot)), notNilAtLeastAsLarge, notNilSmaller))));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        return node.accept(this.methodBodyTranslator);
    }

    public void pushArraySlot(FrameSlot slot) {
        this.arraySlotStack.push(new ArraySlot(slot, this.index));
    }

    public void popArraySlot(FrameSlot slot) {
        this.index = this.arraySlotStack.pop().getPreviousIndex();
    }

    protected boolean useArray() {
        return !this.arraySlotStack.isEmpty();
    }

    protected RubyNode loadArray(RubySourceSection sourceSection) {
        return new ReadLocalVariableNode(this.context, sourceSection.toSourceSection(this.source), LocalVariableType.FRAME_LOCAL, this.arraySlotStack.peek().getArraySlot());
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }

    private static class ArraySlot {
        private FrameSlot arraySlot;
        private int previousIndex;

        public ArraySlot(FrameSlot arraySlot, int previousIndex) {
            this.arraySlot = arraySlot;
            this.previousIndex = previousIndex;
        }

        public FrameSlot getArraySlot() {
            return this.arraySlot;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }
    }
}

