(function() {
  var OnigRegExp, OnigScanner, OnigString;

  OnigScanner = require('../build/Release/onig_scanner.node').OnigScanner;

  OnigString = require('../build/Release/onig_scanner.node').OnigString;

  OnigRegExp = require('./onig-reg-exp');

  OnigScanner.prototype.findNextMatch = function(string, startPosition, callback) {
    if (startPosition == null) {
      startPosition = 0;
    }
    if (typeof startPosition === 'function') {
      callback = startPosition;
      startPosition = 0;
    }
    string = this.convertToString(string);
    startPosition = this.convertToNumber(startPosition);
    return this._findNextMatch(string, startPosition, (function(_this) {
      return function(error, match) {
        if (match != null) {
          match.scanner = _this;
        }
        return typeof callback === "function" ? callback(error, match) : void 0;
      };
    })(this));
  };

  OnigScanner.prototype.findNextMatchSync = function(string, startPosition) {
    var match;
    if (startPosition == null) {
      startPosition = 0;
    }
    string = this.convertToString(string);
    startPosition = this.convertToNumber(startPosition);
    match = this._findNextMatchSync(string, startPosition);
    if (match != null) {
      match.scanner = this;
    }
    return match;
  };

  OnigScanner.prototype.convertToString = function(value) {
    if (value === void 0) {
      return 'undefined';
    } else if (value === null) {
      return 'null';
    } else {
      return value.toString();
    }
  };

  OnigScanner.prototype.convertToNumber = function(value) {
    value = parseInt(value);
    if (!isFinite(value)) {
      value = 0;
    }
    value = Math.max(value, 0);
    return value;
  };

  exports.OnigString = OnigString;

  exports.OnigScanner = OnigScanner;

  exports.OnigRegExp = OnigRegExp;

}).call(this);
