/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.jvm.tasks.api.internal;

public class InnerClassMember extends AccessibleMember implements Comparable<InnerClassMember> {

    private final String outerName;
    private final String innerName;

    public InnerClassMember(int access, String name, String outerName, String innerName) {
        super(access, name);
        this.outerName = outerName;
        this.innerName = innerName;
    }

    public String getInnerName() {
        return innerName;
    }

    public String getOuterName() {
        return outerName;
    }

    @Override
    public int compareTo(InnerClassMember o) {
        return super.compare(o)
            .compare(outerName == null ? "" : outerName, o.outerName == null ? "" : o.outerName)
            .compare(innerName == null ? "" : innerName, o.innerName == null ? "" : o.innerName)
            .result();
    }
}
