/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process.valign;

import org.jfree.layouting.renderer.model.RenderableText;
import org.jfree.layouting.renderer.process.valign.AlignContext;
import org.jfree.layouting.renderer.text.ExtendedBaselineInfo;

public class TextElementAlignContext
extends AlignContext {
    private long[] baselines;
    private long baselineShift;

    public TextElementAlignContext(RenderableText renderableText) {
        super(renderableText);
        ExtendedBaselineInfo extendedBaselineInfo = renderableText.getBaselineInfo();
        this.baselines = extendedBaselineInfo.getBaselines();
        this.setDominantBaseline(extendedBaselineInfo.getDominantBaseline());
    }

    public long getBaselineDistance(int n) {
        return this.baselines[n] - this.baselines[this.getDominantBaseline()] + this.baselineShift;
    }

    public void shift(long l) {
        this.baselineShift += l;
    }

    public long getAfterEdge() {
        return this.baselines[9] + this.baselineShift;
    }

    public long getBeforeEdge() {
        return this.baselines[0] + this.baselineShift;
    }
}

