/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.swing;

public final class LongRect {
    public long x;
    public long y;
    public long width;
    public long height;

    public LongRect() {
        this(0L, 0L, 0L, 0L);
    }

    public LongRect(LongRect longRect) {
        this(longRect.x, longRect.y, longRect.width, longRect.height);
    }

    public LongRect(long l, long l2, long l3, long l4) {
        this.x = l;
        this.y = l2;
        this.width = l3;
        this.height = l4;
    }

    public String toString() {
        return "LongRect: [" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "]";
    }

    public static void clear(LongRect longRect) {
        longRect.x = 0L;
        longRect.y = 0L;
        longRect.width = 0L;
        longRect.height = 0L;
    }

    public static boolean isClear(LongRect longRect) {
        if (longRect.x != 0L) {
            return false;
        }
        if (longRect.y != 0L) {
            return false;
        }
        if (longRect.width != 0L) {
            return false;
        }
        return longRect.height == 0L;
    }

    public static boolean isEmpty(LongRect longRect) {
        if (longRect.width <= 0L) {
            return true;
        }
        return longRect.height <= 0L;
    }

    public static void set(LongRect longRect, LongRect longRect2) {
        LongRect.set(longRect, longRect2.x, longRect2.y, longRect2.width, longRect2.height);
    }

    public static void set(LongRect longRect, long l, long l2, long l3, long l4) {
        longRect.x = l;
        longRect.y = l2;
        longRect.width = l3;
        longRect.height = l4;
    }

    public static void add(LongRect longRect, LongRect longRect2) {
        if (LongRect.isEmpty(longRect2)) {
            return;
        }
        if (LongRect.isEmpty(longRect)) {
            longRect.x = longRect2.x;
            longRect.y = longRect2.y;
            longRect.width = longRect2.width;
            longRect.height = longRect2.height;
        } else {
            long l = longRect.x;
            long l2 = longRect.y;
            longRect.x = Math.min(longRect.x, longRect2.x);
            longRect.y = Math.min(longRect.y, longRect2.y);
            longRect.width = Math.max(l + longRect.width, longRect2.x + longRect2.width) - longRect.x;
            longRect.height = Math.max(l2 + longRect.height, longRect2.y + longRect2.height) - longRect.y;
        }
    }

    public static void add(LongRect longRect, long l, long l2) {
        long l3 = longRect.x;
        long l4 = longRect.y;
        longRect.x = Math.min(longRect.x, l);
        longRect.y = Math.min(longRect.y, l2);
        longRect.width = Math.max(l3 + longRect.width, l) - longRect.x;
        longRect.height = Math.max(l4 + longRect.height, l2) - longRect.y;
    }

    public static boolean contains(LongRect longRect, LongRect longRect2) {
        if (LongRect.isEmpty(longRect) || LongRect.isEmpty(longRect2)) {
            return false;
        }
        if (longRect.x > longRect2.x) {
            return false;
        }
        if (longRect.y > longRect2.y) {
            return false;
        }
        if (longRect.x + longRect.width < longRect2.x + longRect2.width) {
            return false;
        }
        return longRect.y + longRect.height >= longRect2.y + longRect2.height;
    }

    public static boolean equals(LongRect longRect, LongRect longRect2) {
        if (longRect.x != longRect2.x) {
            return false;
        }
        if (longRect.y != longRect2.y) {
            return false;
        }
        if (longRect.width != longRect2.width) {
            return false;
        }
        return longRect.height == longRect2.height;
    }

    public static boolean touches(LongRect longRect, LongRect longRect2) {
        if (LongRect.isEmpty(longRect) || LongRect.isEmpty(longRect2)) {
            return false;
        }
        if (longRect.x == longRect2.x) {
            return true;
        }
        if (longRect.y == longRect2.y) {
            return true;
        }
        if (longRect.x + longRect.width == longRect2.x + longRect2.width) {
            return true;
        }
        return longRect.y + longRect.height == longRect2.y + longRect2.height;
    }

    public static void addBorder(LongRect longRect, long l) {
        longRect.x -= l;
        longRect.y -= l;
        longRect.width += l * 2L;
        longRect.height += l * 2L;
    }
}

