/* data_adapters.hh
 * This file is part of cdbxx library
 * Copyright (c) 2004 by Stanislav Ievlev
 *
 * This file is covered by the GNU Library General Public License,
 * which should be included with libcdbxx as the file COPYING.
 */
#ifndef CDB_XX_DATA_ADAPTERS_HH__
#define CDB_XX_DATA_ADAPTERS_HH__

#include <string>
#include <vector>

namespace cdbxx
{
	/**
	 * adapter from data container to string
	 */
	class string
	{
	public:
	    string(const data& item):
		str_(reinterpret_cast<const char*>(item.data_),
		     reinterpret_cast<const char*>(item.data_) + item.len_)
	    {}
	    std::string& get()
	    {
		return str_;
	    }
	    bool equal(const std::string& other) const
	    {
		return (str_ == other);
	    }
	private:
	    std::string str_;
	};
	
	inline bool operator==(const std::string& lhs,const cdbxx::string& rhs)
	{
	    return rhs.equal(lhs);
	}

	inline bool operator==(const cdbxx::string& lhs,const std::string& rhs)
	{
	    return lhs.equal(rhs);
	}

	inline bool operator!=(const std::string& lhs,const cdbxx::string& rhs)
	{
	    return (!rhs.equal(lhs));
	}

	inline bool operator!=(const cdbxx::string& lhs,const std::string& rhs)
	{
	    return (!lhs.equal(rhs));
	}

	/**
	 * adapter from data container to vector
	 */
	template <class T>
	class vector
	{
	public:
	    vector(const data& item)
	    {
		unsigned char *begin = const_cast<unsigned char*>(item.data_);
		//we need non const char to made assigment like this
		vec_.assign(reinterpret_cast<T*>(begin), reinterpret_cast<T*>(begin) + item.len_);
	    }
	    std::vector<T>& get()
	    {
		return vec_;
	    }
	    bool equal(const std::vector<T>& other) const
	    {
		return (vec_ == other);
	    }
	private:
	    std::vector<T> vec_;
	};
	
	template <class T>
	inline bool operator==(const std::vector<T>& lhs,const cdbxx::vector<T>& rhs)
	{
	    return rhs.equal(lhs);
	}

	template <class T>
	inline bool operator==(const cdbxx::vector<T>& lhs,const std::vector<T>& rhs)
	{
	    return lhs.equal(rhs);
	}

	template <class T>
	inline bool operator!=(const std::vector<T>& lhs,const cdbxx::vector<T>& rhs)
	{
	    return (!rhs.equal(lhs));
	}

	template <class T>
	inline bool operator!=(const cdbxx::vector<T>& lhs,const std::vector<T>& rhs)
	{
	    return (!lhs.equal(rhs));
	}
}

#endif
