/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;

class SearchScrollQueryAndFetchAsyncAction
extends AbstractAsyncAction {
    private final Logger logger;
    private final SearchPhaseController searchPhaseController;
    private final SearchTransportService searchTransportService;
    private final SearchScrollRequest request;
    private final SearchTask task;
    private final ActionListener<SearchResponse> listener;
    private final ParsedScrollId scrollId;
    private final DiscoveryNodes nodes;
    private volatile AtomicArray<ShardSearchFailure> shardFailures;
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;
    private final AtomicInteger successfulOps;
    private final AtomicInteger counter;

    SearchScrollQueryAndFetchAsyncAction(Logger logger, ClusterService clusterService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, SearchScrollRequest request, SearchTask task, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        this.logger = logger;
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.request = request;
        this.task = task;
        this.listener = listener;
        this.scrollId = scrollId;
        this.nodes = clusterService.state().nodes();
        this.successfulOps = new AtomicInteger(scrollId.getContext().length);
        this.counter = new AtomicInteger(scrollId.getContext().length);
        this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
    }

    protected final ShardSearchFailure[] buildShardFailures() {
        if (this.shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = (ShardSearchFailure)entries.get((int)i).value;
        }
        return failures;
    }

    protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
        if (this.shardFailures == null) {
            this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
        }
        this.shardFailures.set(shardIndex, failure);
    }

    @Override
    public void start() {
        if (this.scrollId.getContext().length == 0) {
            this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        ScrollIdForNode[] context = this.scrollId.getContext();
        for (int i = 0; i < context.length; ++i) {
            ScrollIdForNode target = context[i];
            DiscoveryNode node = this.nodes.get(target.getNode());
            if (node != null) {
                this.executePhase(i, node, target.getScrollId());
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Node [{}] not available for scroll request [{}]", (Object)target.getNode(), (Object)this.scrollId.getSource());
            }
            this.successfulOps.decrementAndGet();
            if (this.counter.decrementAndGet() != 0) continue;
            this.finishHim();
        }
        for (ScrollIdForNode target : this.scrollId.getContext()) {
            DiscoveryNode node = this.nodes.get(target.getNode());
            if (node != null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Node [{}] not available for scroll request [{}]", (Object)target.getNode(), (Object)this.scrollId.getSource());
            }
            this.successfulOps.decrementAndGet();
            if (this.counter.decrementAndGet() != 0) continue;
            this.finishHim();
        }
    }

    void executePhase(final int shardIndex, DiscoveryNode node, final long searchId) {
        InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(searchId, this.request);
        this.searchTransportService.sendExecuteFetch(node, internalRequest, this.task, new ActionListener<ScrollQueryFetchSearchResult>(){

            @Override
            public void onResponse(ScrollQueryFetchSearchResult result) {
                SearchScrollQueryAndFetchAsyncAction.this.queryFetchResults.set(shardIndex, result.result());
                if (SearchScrollQueryAndFetchAsyncAction.this.counter.decrementAndGet() == 0) {
                    SearchScrollQueryAndFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Exception t) {
                SearchScrollQueryAndFetchAsyncAction.this.onPhaseFailure(t, searchId, shardIndex);
            }
        });
    }

    private void onPhaseFailure(Exception e, long searchId, int shardIndex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)searchId), (Throwable)e);
        }
        this.addShardFailure(shardIndex, new ShardSearchFailure(e));
        this.successfulOps.decrementAndGet();
        if (this.counter.decrementAndGet() == 0) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query_fetch", "all shards failed", e, this.buildShardFailures()));
            } else {
                this.finishHim();
            }
        }
    }

    private void finishHim() {
        try {
            this.innerFinishHim();
        }
        catch (Exception e) {
            this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
        }
    }

    private void innerFinishHim() throws Exception {
        ScoreDoc[] sortedShardDocs = this.searchPhaseController.sortDocs(true, this.queryFetchResults);
        InternalSearchResponse internalResponse = this.searchPhaseController.merge(true, sortedShardDocs, this.queryFetchResults, this.queryFetchResults);
        String scrollId = null;
        if (this.request.scroll() != null) {
            scrollId = this.request.scrollId();
        }
        this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
    }
}

